/*
 * Decompiled with CFR 0.152.
 */
package glm.vec._3.i;

import glm.Glm;
import glm.vec._3.i.FuncRelational;
import glm.vec._4.i.Vec4i;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class Vec3i
extends FuncRelational {
    public Vec3i() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public Vec3i(Vec3i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3i(Vec4i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3i(int i) {
        this.x = i;
        this.y = i;
        this.z = i;
    }

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i(int[] fa) {
        this(fa, 0);
    }

    public Vec3i(int[] fa, int i) {
        this.x = fa[i + 0];
        this.y = fa[i + 1];
        this.z = fa[i + 2];
    }

    public Vec3i(long x, long y, long z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
    }

    public Vec3i set(int i) {
        this.x = i;
        this.y = i;
        this.z = i;
        return this;
    }

    public Vec3i set(long x, long y, long z) {
        return this.set((int)x, (int)y, (int)z);
    }

    public Vec3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3i set(int[] fa) {
        this.x = fa[0];
        this.y = fa[1];
        this.z = fa[2];
        return this;
    }

    public static Vec3i linearRand_(Vec3i min, Vec3i max) {
        return Vec3i.linearRand(min, max, new Vec3i());
    }

    public static Vec3i linearRand(Vec3i min, Vec3i max, Vec3i res) {
        res.x = Glm.linearRand(min.x, max.x);
        res.y = Glm.linearRand(min.y, max.y);
        res.z = Glm.linearRand(min.z, max.z);
        return res;
    }

    public Vec3i negate() {
        return this.negate(this);
    }

    public Vec3i negate_() {
        return this.negate(new Vec3i());
    }

    public Vec3i negate(Vec3i res) {
        res.x = -this.x;
        res.y = -this.y;
        res.z = -this.z;
        return res;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public int[] toIA_() {
        return this.toIA(new int[3]);
    }

    public int[] toIA(int[] ia) {
        ia[0] = this.x;
        ia[1] = this.y;
        ia[2] = this.z;
        return ia;
    }

    public IntBuffer toDib_() {
        return this.toDib(ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asIntBuffer());
    }

    public IntBuffer toDib(IntBuffer ib) {
        return this.toDib(ib, 0);
    }

    public IntBuffer toDib(IntBuffer ib, int index) {
        return ib.put(index + 0, this.x).put(index + 1, this.y).put(index + 2, this.z);
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()));
    }

    public ByteBuffer toDbb(ByteBuffer bb) {
        return this.toDbb(bb, 0);
    }

    public ByteBuffer toDbb(ByteBuffer bb, int index) {
        return bb.putInt(index + 0, this.x).putInt(index + 4, this.y).putInt(index + 8, this.z);
    }

    public void print() {
        this.print("", System.out);
    }

    public void print(String title) {
        this.print(title, System.out);
    }

    public void print(String title, PrintStream printStream) {
        printStream.println(title + "\n(" + this.x + ", " + this.y + ", " + this.z + ")");
    }
}

