/*
 * Decompiled with CFR 0.152.
 */
package jglm;

import jglm.Vec;
import jglm.Vec2i;

public class Vec2
extends Vec {
    public float x;
    public float y;

    public Vec2() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vec2(float[] floatArray) {
        this.vector = floatArray;
        this.x = this.vector[0];
        this.y = this.vector[1];
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
        this.vector = new float[]{x, y};
    }

    public Vec2(float[] floatArray, int i) {
        this.vector = new float[]{floatArray[i], floatArray[i + 1]};
        this.x = this.vector[0];
        this.y = this.vector[1];
    }

    public Vec2 normalize() {
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        return new Vec2(this.x / length, this.y / length);
    }

    public Vec2 times(float scalar) {
        return new Vec2(this.x * scalar, this.y * scalar);
    }

    public Vec2 plus(Vec2 vec2) {
        return new Vec2(this.x + vec2.x, this.y + vec2.y);
    }

    public Vec2 minus(Vec2 vec2) {
        return new Vec2(this.x - vec2.x, this.y - vec2.y);
    }

    public Vec2 minus(Vec2i vec2) {
        return new Vec2(this.x - (float)vec2.x, this.y - (float)vec2.y);
    }

    public Vec2 negated() {
        return new Vec2(-this.x, -this.y);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void print() {
        System.out.println("(" + this.x + ", " + this.y + ")");
    }

    public void print(String title) {
        System.out.println(title + " (" + this.x + ", " + this.y + ")");
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y};
    }
}

