/*
 * Decompiled with CFR 0.152.
 */
package jglm;

import jglm.Quat;
import jglm.Vec;
import jglm.Vec4;

public class Vec3
extends Vec {
    public float x;
    public float y;
    public float z;

    public Vec3() {
    }

    public Vec3(float[] floatArray) {
        this.vector = floatArray;
        this.x = this.vector[0];
        this.y = this.vector[1];
        this.z = this.vector[2];
    }

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vector = new float[]{x, y, z};
    }

    public Vec3(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
        this.vector = new float[]{f, f, f};
    }

    public Vec3(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.vector = new float[]{this.x, this.y, this.z};
    }

    public Vec3(float[] floatArray, int i) {
        this.vector = new float[]{floatArray[i], floatArray[i + 1], floatArray[i + 2]};
        this.x = this.vector[0];
        this.y = this.vector[1];
        this.z = this.vector[2];
    }

    public Vec3(Vec4 vec4) {
        this.x = vec4.x;
        this.y = vec4.y;
        this.z = vec4.z;
        this.vector = new float[]{this.x, this.y, this.z};
    }

    public static Vec3 getMiddlePoint(Vec3 p1, Vec3 p2) {
        return new Vec3((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f, (p1.z + p2.z) / 2.0f);
    }

    public Vec3 normalize() {
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return length != 0.0f ? new Vec3(this.x / length, this.y / length, this.z / length) : new Vec3();
    }

    public float dot(Vec3 vec3) {
        return this.x * vec3.x + this.y * vec3.y + this.z * vec3.z;
    }

    public Vec3 times(float scalar) {
        return new Vec3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public static Vec3 mix(Vec3 start, Vec3 end, float lerp) {
        Vec3 result = end.minus(start);
        result = result.times(lerp);
        result = start.plus(result);
        return result;
    }

    public Vec3 times(Quat quat) {
        Vec3 q = new Vec3(quat.x, quat.y, quat.z);
        Vec3 t = q.crossProduct(this);
        t = t.times(2.0f);
        t = t.times(quat.w).plus(q.crossProduct(t));
        Vec3 v = t.plus(this);
        return v;
    }

    public Vec3 transformQuat(Quat quat) {
        Vec3 result = new Vec3();
        Quat i = new Quat();
        i.x = quat.w * this.x + quat.y * this.z - quat.z * this.y;
        i.y = quat.w * this.y + quat.z * this.x - quat.x * this.z;
        i.z = quat.w * this.z + quat.x * this.y - quat.y * this.x;
        i.w = -quat.x * this.x - quat.y * this.y - quat.z * this.z;
        result.x = i.x * quat.w + i.w * -quat.x + i.y * -quat.z - i.z * -quat.y;
        result.y = i.y * quat.w + i.w * -quat.y + i.z * -quat.x - i.x * -quat.z;
        result.z = i.z * quat.w + i.w * -quat.z + i.x * -quat.y - i.y * -quat.x;
        return result;
    }

    public Vec3 plus(Vec3 vec3) {
        return new Vec3(this.x + vec3.x, this.y + vec3.y, this.z + vec3.z);
    }

    public Vec3 minus(Vec3 vec3) {
        return new Vec3(this.x - vec3.x, this.y - vec3.y, this.z - vec3.z);
    }

    public Vec3 crossProduct(Vec3 vec3) {
        return new Vec3(this.y * vec3.z - this.z * vec3.y, this.z * vec3.x - this.x * vec3.z, this.x * vec3.y - this.y * vec3.x);
    }

    public Vec3 negated() {
        return new Vec3(-this.x, -this.y, -this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void print() {
        System.out.println("(" + this.x + ", " + this.y + ", " + this.z + ")");
    }

    public void print(String title) {
        System.out.println(title + " (" + this.x + ", " + this.y + ", " + this.z + ")");
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public float getDistance(Vec3 v) {
        return (float)Math.sqrt(Math.pow(this.x - v.x, 2.0) + Math.pow(this.y - v.y, 2.0) + Math.pow(this.z - v.z, 2.0));
    }

    public boolean isEqual(Vec3 second) {
        boolean equal = true;
        for (int i = 0; i < 3; ++i) {
            if (this.toFloatArray()[i] == second.toFloatArray()[i]) continue;
            equal = false;
        }
        return equal;
    }
}

