/*
 * Decompiled with CFR 0.152.
 */
package joou;

import java.math.BigInteger;
import joou.UNumber;

public final class UByte
extends UNumber
implements Comparable<UByte> {
    private static final long serialVersionUID = -6821055240959745390L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 255;
    public byte value;

    public UByte() {
        this.value = 0;
    }

    public UByte(byte value) {
        this.value = value;
    }

    public UByte(short value) {
        this.value = (byte)value;
    }

    public UByte(int value) {
        this.value = (byte)value;
    }

    public UByte(long value) {
        this.value = (byte)value;
    }

    public UByte(BigInteger value) {
        this.value = value.byteValue();
    }

    public UByte(String value) {
        this.value = Byte.parseByte(value);
    }

    public UByte(UByte uByte) {
        this.value = uByte.value;
    }

    public int hashCode() {
        return Short.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UByte) {
            return this.value == ((UByte)obj).value;
        }
        return false;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    @Override
    public int compareTo(UByte o) {
        int a = this.value & 0xFF;
        int b = o.value & 0xFF;
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public short shortValue() {
        return (short)(this.value & 0xFF);
    }

    public int intValue() {
        return this.value & 0xFF;
    }

    public long longValue() {
        return this.value & 0xFF;
    }

    public static byte checkSigned(byte value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static byte checkSigned(short value) throws ArithmeticException {
        if (value < 0 || value > 255) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (byte)value;
    }

    public static byte checkSigned(int value) throws ArithmeticException {
        if (value < 0 || value > 255) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (byte)value;
    }

    public static byte checkSigned(long value) throws ArithmeticException {
        if (value < 0L || value > 255L) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (byte)value;
    }

    public static byte checkSigned(BigInteger value) throws ArithmeticException {
        if (value.compareTo(BigInteger.ZERO) < 0 || value.intValue() > 255) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value.byteValue();
    }

    public static byte checkSigned(String value) throws ArithmeticException {
        if (value.startsWith("-")) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return Byte.parseByte(value);
    }
}

