/*
 * Decompiled with CFR 0.152.
 */
package joou;

import java.math.BigInteger;
import joou.UNumber;

public final class UInt
extends UNumber
implements Comparable<UInt> {
    private static final long serialVersionUID = -6821055240959745390L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = -1;
    public int value;

    public UInt() {
        this.value = 0;
    }

    public UInt(byte value) {
        this.value = value;
    }

    public UInt(short value) {
        this.value = value;
    }

    public UInt(int value) {
        this.value = value;
    }

    public UInt(long value) {
        this.value = (int)value;
    }

    public UInt(BigInteger value) {
        this.value = value.intValue();
    }

    public UInt(String value) {
        this.value = Integer.parseInt(value);
    }

    public UInt(UInt uInteger) {
        this.value = uInteger.value;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UInt) {
            return this.value == ((UInt)obj).value;
        }
        return false;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int compareTo(UInt o) {
        return Integer.compareUnsigned(this.value, o.value);
    }

    public long longValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public static int checkSigned(byte value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static int checkSigned(short value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static int checkSigned(int value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static int checkSigned(long value) throws ArithmeticException {
        if (value < 0L || value > -1L) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (int)value;
    }

    public static int checkSigned(BigInteger value) throws ArithmeticException {
        if (value.compareTo(BigInteger.ZERO) < 0 || value.longValue() > -1L) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value.intValue();
    }

    public static int checkSigned(String value) throws ArithmeticException {
        if (value.startsWith("-")) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return Integer.parseInt(value);
    }
}

