/*
 * Decompiled with CFR 0.152.
 */
package joou;

import java.math.BigInteger;
import joou.UNumber;

public final class UShort
extends UNumber
implements Comparable<UShort> {
    private static final long serialVersionUID = -6821055240959745390L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    public short value;

    public UShort() {
        this.value = 0;
    }

    public UShort(byte value) {
        this.value = value;
    }

    public UShort(short value) {
        this.value = value;
    }

    public UShort(int value) {
        this.value = (short)value;
    }

    public UShort(long value) {
        this.value = (short)value;
    }

    public UShort(BigInteger value) {
        this.value = value.shortValue();
    }

    private UShort(String value) {
        this.value = Short.parseShort(value);
    }

    public UShort(UShort uShort) {
        this.value = uShort.value;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UShort) {
            return this.value == ((UShort)obj).value;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int compareTo(UShort o) {
        short a = this.value;
        short b = o.value;
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public int intValue() {
        return this.value & 0xFFFF;
    }

    public long longValue() {
        return this.value & 0xFFFF;
    }

    public static short checkSigned(byte value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static short checkSigned(short value) throws ArithmeticException {
        if (value < 0) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value;
    }

    public static short checkSigned(int value) throws ArithmeticException {
        if (value < 0 || value > 65535) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (short)value;
    }

    public static short checkSigned(long value) throws ArithmeticException {
        if (value < 0L || value > 65535L) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return (short)value;
    }

    public static short checkSigned(BigInteger value) throws ArithmeticException {
        if (value.compareTo(BigInteger.ZERO) < 0 || value.intValue() > 65535) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return value.shortValue();
    }

    public static short checkSigned(String value) throws ArithmeticException {
        if (value.startsWith("-")) {
            throw new ArithmeticException("Value is out of range : " + value);
        }
        return Short.parseShort(value);
    }
}

