/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen;

import io.gorules.zen.ZenEngineConfig;
import io.gorules.zen.ZenEngineWrapper;
import io.gorules.zen.loader.ApiDecisionLoader;
import io.gorules.zen.loader.ApiLoaderConfig;
import io.gorules.zen.loader.ClasspathDecisionLoader;
import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen.loader.FilesystemDecisionLoader;
import io.gorules.zen.loader.MemoryDecisionLoader;

public class ZenEngineBuilder {
    private DecisionLoader loader;
    private int maxDepth = 5;
    private boolean enableTrace = false;

    private ZenEngineBuilder() {
    }

    public static ZenEngineBuilder create() {
        return new ZenEngineBuilder();
    }

    public ZenEngineBuilder withFilesystemLoader(String rootPath) {
        this.loader = new FilesystemDecisionLoader(rootPath);
        return this;
    }

    public ZenEngineBuilder withClasspathLoader(String rootPath) {
        this.loader = new ClasspathDecisionLoader(rootPath);
        return this;
    }

    public ZenEngineBuilder withMemoryLoader() {
        this.loader = new MemoryDecisionLoader();
        return this;
    }

    public ZenEngineBuilder withApiLoader(String baseUrl) {
        ApiLoaderConfig config = ApiLoaderConfig.builder(baseUrl).build();
        this.loader = new ApiDecisionLoader(config);
        return this;
    }

    public ZenEngineBuilder withApiLoader(String baseUrl, String bearerToken) {
        ApiLoaderConfig config = ApiLoaderConfig.builder(baseUrl).bearerToken(bearerToken).build();
        this.loader = new ApiDecisionLoader(config);
        return this;
    }

    public ZenEngineBuilder withApiLoader(ApiLoaderConfig config) {
        this.loader = new ApiDecisionLoader(config);
        return this;
    }

    public ZenEngineBuilder withLoader(DecisionLoader loader) {
        this.loader = loader;
        return this;
    }

    public ZenEngineBuilder withMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public ZenEngineBuilder withTracing(boolean enable) {
        this.enableTrace = enable;
        return this;
    }

    public ZenEngineWrapper build() {
        if (this.loader == null) {
            this.loader = new ClasspathDecisionLoader("decisions/");
        }
        ZenEngineConfig config = new ZenEngineConfig(this.loader, this.maxDepth, this.enableTrace);
        return new ZenEngineWrapper(config);
    }
}

