/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;

public class FilesystemDecisionLoader
implements DecisionLoader {
    private final String rootPath;

    public FilesystemDecisionLoader(String rootPath) {
        this.rootPath = rootPath.endsWith("/") ? rootPath : rootPath + "/";
    }

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Paths.get(this.rootPath + key, new String[0]);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    throw new RuntimeException("Decision file not found: " + String.valueOf(filePath));
                }
                byte[] content = Files.readAllBytes(filePath);
                JsonBuffer buffer = new JsonBuffer(content);
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load decision: " + key, e);
            }
        });
    }

    public String getRootPath() {
        return this.rootPath;
    }
}

