/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.xml.tiny;

import giis.portable.xml.tiny.XNodeAbstract;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XNode
extends XNodeAbstract {
    private Node node = null;

    public XNode(String xml) {
        Document doc = XNode.newDocument(xml);
        this.node = doc.getFirstChild();
    }

    private XNode(Node nativeNode) {
        this.node = nativeNode;
    }

    @Override
    public String getAttribute(String name) {
        if (!this.isElement(this.node)) {
            return "";
        }
        return ((Element)this.node).getAttribute(name);
    }

    @Override
    public void setAttribute(String name, String value) {
        if (!this.isElement(this.node)) {
            return;
        }
        ((Element)this.node).setAttribute(name, value);
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> attrs = new ArrayList<String>();
        if (!this.isElement(this.node)) {
            return attrs;
        }
        NamedNodeMap xattrs = this.node.getAttributes();
        for (int i = 0; i < xattrs.getLength(); ++i) {
            attrs.add(xattrs.item(i).getNodeName());
        }
        Collections.sort(attrs);
        return attrs;
    }

    @Override
    public XNode getChild(String elementName) {
        List<XNode> children = this.getChildren(elementName, false);
        if (children.size() > 0) {
            return children.get(0);
        }
        return null;
    }

    @Override
    public List<XNode> getChildren(String elementName) {
        return this.getChildren(elementName, true);
    }

    @Override
    public XNode getFirstChild() {
        return new XNode(this.node.getFirstChild());
    }

    @Override
    public String name() {
        return this.node.getNodeName();
    }

    @Override
    public String innerText() {
        if (this.node.getNodeType() == 3) {
            return this.node.getNodeValue();
        }
        StringBuilder sb = new StringBuilder();
        NodeList nl = this.node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            sb.append(new XNode(nl.item(i)).innerText());
        }
        return sb.toString();
    }

    @Override
    public void setInnerText(String value) {
        if (this.node.getNodeType() == 3) {
            this.node.setNodeValue(value);
            return;
        }
        NodeList nl = this.node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            this.node.removeChild(nl.item(i));
        }
        Text newChild = this.node.getOwnerDocument().createTextNode(value);
        this.node.appendChild(newChild);
    }

    @Override
    public XNode appendChild(String elementName) {
        Element newChild = this.node.getOwnerDocument().createElement(elementName);
        this.node.appendChild(newChild);
        return new XNode(newChild);
    }

    @Override
    public String outerXml() {
        return this.toXmlString(this.node, true);
    }

    @Override
    public String innerXml() {
        return this.toXmlString(this.node, false);
    }

    public String toString() {
        return this.outerXml();
    }

    public static Document newDocument(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException(e1);
        }
        catch (SAXException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private List<XNode> getChildren(String elementName, boolean returnAll) {
        ArrayList<XNode> children = new ArrayList<XNode>();
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.isElement(child) || !child.getNodeName().equals(elementName)) continue;
            children.add(new XNode(child));
            if (returnAll) continue;
            return children;
        }
        return children;
    }

    private boolean isElement(Node n) {
        return n.getNodeType() == 1;
    }

    private String toXmlString(Node n, boolean viewRoot) {
        String nodeName = n.getNodeName();
        switch (n.getNodeType()) {
            case 3: {
                if (viewRoot) {
                    return XNode.encodeText(n.getNodeValue());
                }
                return "";
            }
            case 1: {
                String attr = this.getAttributesString(n);
                if (n.hasChildNodes()) {
                    return this.getChildrenRecursive(n, nodeName, attr, viewRoot);
                }
                if (viewRoot) {
                    return "<" + nodeName + attr + " />";
                }
                return "";
            }
        }
        return "";
    }

    private String getChildrenRecursive(Node n, String nodeName, String attr, boolean viewRoot) {
        StringBuilder sb = new StringBuilder();
        if (viewRoot) {
            sb.append("<" + nodeName + attr + ">");
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            sb.append(this.toXmlString(child, true));
        }
        if (viewRoot) {
            sb.append("</" + nodeName + ">");
        }
        return sb.toString();
    }

    private String getAttributesString(Node n) {
        StringBuilder attr = new StringBuilder();
        if (this.isElement(n) && n.hasAttributes()) {
            for (int i = 0; i < n.getAttributes().getLength(); ++i) {
                String aName = n.getAttributes().item(i).getNodeName();
                String aValue = n.getAttributes().item(i).getNodeValue();
                attr.append(" " + aName + "=\"" + XNode.encodeAttribute(aValue) + "\"");
            }
        }
        return attr.toString();
    }
}

