/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.xml.tiny;

import giis.portable.xml.tiny.XNodeAbstract;
import giis.portable.xml.tiny.XmlException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XNode
extends XNodeAbstract {
    protected Node node = null;

    public XNode(String xml) {
        Document doc = XNode.newDocument(xml);
        this.node = doc.getFirstChild();
    }

    public XNode(Node nativeNode) {
        this.node = nativeNode;
    }

    public Node getNativeNode() {
        return this.node;
    }

    private XNode newXNode(Node nativeNode) {
        return nativeNode == null ? null : new XNode(nativeNode);
    }

    @Override
    public boolean equals(XNode xn) {
        if (this.node == null || xn == null || xn.getNativeNode() == null) {
            return false;
        }
        return this.node.equals(xn.getNativeNode());
    }

    @Override
    public boolean isElement() {
        return this.node.getNodeType() == 1;
    }

    @Override
    public boolean isText() {
        return this.node.getNodeType() == 3;
    }

    @Override
    public boolean isWhitespace() {
        return this.isBlank(this.node);
    }

    private boolean isBlank(Node n) {
        if (n == null) {
            return false;
        }
        if (n.getNodeType() == 3) {
            String nodeText = n.getNodeValue();
            for (int i = 0; i < nodeText.length(); ++i) {
                if (nodeText.charAt(i) == ' ' || nodeText.charAt(i) == '\n' || nodeText.charAt(i) == '\r' || nodeText.charAt(i) == '\t') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public XNode createElement(String elementName) {
        return this.newXNode(this.node.getOwnerDocument().createElement(elementName));
    }

    @Override
    public XNode createText(String textValue) {
        return this.newXNode(this.node.getOwnerDocument().createTextNode(textValue));
    }

    @Override
    public String name() {
        return this.node.getNodeName();
    }

    @Override
    public String value() {
        return this.node.getNodeValue();
    }

    @Override
    public void setValue(String value) {
        this.node.setNodeValue(value);
    }

    @Override
    public String innerText() {
        if (this.node.getNodeType() == 3) {
            return this.node.getNodeValue();
        }
        StringBuilder sb = new StringBuilder();
        NodeList nl = this.node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            sb.append(this.newXNode(nl.item(i)).innerText());
        }
        return sb.toString();
    }

    @Override
    public void setInnerText(String value) {
        if (this.node.getNodeType() == 3) {
            this.node.setNodeValue(value);
            return;
        }
        NodeList nl = this.node.getChildNodes();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            this.node.removeChild(nl.item(i));
        }
        Text newChild = this.node.getOwnerDocument().createTextNode(value);
        this.node.appendChild(newChild);
    }

    @Override
    public String outerXml() {
        return this.toXmlString(this.node, true);
    }

    @Override
    public String innerXml() {
        return this.toXmlString(this.node, false);
    }

    @Override
    public void setInnerXml(String value) {
        if (this.node.getNodeType() == 3) {
            throw new XmlException("XNode.setInnerXml: Only allowed for Element nodes");
        }
        this.removeChildren();
        if (value.equals("")) {
            return;
        }
        Document d = XNode.newDocument("<document>" + value + "</document>");
        Node n = d.getFirstChild();
        NodeList nlist = n.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node adopted = this.node.getOwnerDocument().importNode(nlist.item(i), true);
            this.node.appendChild(adopted);
        }
    }

    public void removeChildren() {
        while (this.node.getFirstChild() != null) {
            this.node.removeChild(this.node.getFirstChild());
        }
    }

    public String toString() {
        return this.outerXml();
    }

    @Override
    public String getAttribute(String name) {
        if (!this.isElement()) {
            return "";
        }
        return ((Element)this.node).getAttribute(name);
    }

    @Override
    public void setAttribute(String name, String value) {
        if (!this.isElement()) {
            return;
        }
        ((Element)this.node).setAttribute(name, value);
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> attrs = new ArrayList<String>();
        if (!this.isElement()) {
            return attrs;
        }
        NamedNodeMap xattrs = this.node.getAttributes();
        for (int i = 0; i < xattrs.getLength(); ++i) {
            attrs.add(xattrs.item(i).getNodeName());
        }
        Collections.sort(attrs);
        return attrs;
    }

    @Override
    public String getAttributesString() {
        return this.getAttributesString(this.node);
    }

    @Override
    public XNode cloneNode() {
        return this.newXNode(this.node.cloneNode(true));
    }

    @Override
    public XNode importNode(XNode source) {
        Node xnn = source.getNativeNode();
        Node xni = this.node.getOwnerDocument().importNode(xnn, true);
        return this.newXNode(xni);
    }

    @Override
    public XNode createNode(String xml) {
        XNode n = this.createElement("newnode");
        n.setInnerXml(xml);
        return n.firstChild();
    }

    @Override
    public void normalize() {
        this.node.normalize();
    }

    @Override
    public XNode removeChild(XNode oldChild) {
        return this.newXNode(this.node.removeChild(oldChild.getNativeNode()));
    }

    @Override
    public XNode appendChild(XNode elementOrTextNode) {
        Node newChild = this.node.appendChild(elementOrTextNode.getNativeNode());
        return this.newXNode(newChild);
    }

    @Override
    public XNode prependChild(XNode node) {
        XNode first = this.firstChild();
        if (first == null) {
            return this.appendChild(node);
        }
        return first.insertBefore(node);
    }

    @Override
    public XNode replaceChild(XNode newChild, XNode oldChild) {
        return this.newXNode(this.node.replaceChild(newChild.node, oldChild.node));
    }

    @Override
    public XNode insertBefore(XNode newChild) {
        return this.newXNode(this.node.getParentNode().insertBefore(newChild.getNativeNode(), this.node));
    }

    @Override
    public XNode insertAfter(XNode newChild) {
        if (this.nextSibling() == null) {
            return this.parent().appendChild(newChild);
        }
        return this.nextSibling().insertBefore(newChild);
    }

    @Override
    public void removeAttribute(String name) {
        try {
            ((Element)this.node).removeAttribute(name);
        }
        catch (ClassCastException e) {
            throw new XmlException("XNode.removeAttribute: Operacion no permitida si el nodo no es Element", e);
        }
    }

    @Override
    public boolean isRoot() {
        XNode parent = this.parent();
        return parent == null || parent.getNativeNode().getNodeType() == 9;
    }

    @Override
    public XNode root() {
        Node n = this.node.getOwnerDocument().getFirstChild();
        return new XNode(n);
    }

    @Override
    public XNode parent() {
        Node parent = this.node.getParentNode();
        return parent == null || parent.getNodeType() == 9 ? null : this.newXNode(parent);
    }

    @Override
    public XNode firstChild() {
        Node n = this.node.getFirstChild();
        n = this.skipBlankSiblings(n, true);
        return this.newXNode(n);
    }

    @Override
    public XNode nextSibling() {
        Node n = this.node.getNextSibling();
        n = this.skipBlankSiblings(n, true);
        return this.newXNode(n);
    }

    @Override
    public XNode previousSibling() {
        Node n = this.node.getPreviousSibling();
        n = this.skipBlankSiblings(n, false);
        return this.newXNode(n);
    }

    private Node skipBlankSiblings(Node n, boolean forward) {
        while (this.isBlank(n)) {
            n = forward ? n.getNextSibling() : n.getPreviousSibling();
        }
        return n;
    }

    public static Document newDocument(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlException(e);
        }
    }

    @Override
    protected List<XNode> getChildren(boolean returnElements, boolean returnTexts, String elementName, boolean onlyFirst) {
        ArrayList<XNode> children = new ArrayList<XNode>();
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if ((!returnElements || child.getNodeType() != 1 || elementName != null && !child.getNodeName().equals(elementName)) && (!returnTexts || child.getNodeType() != 3 || this.isBlank(child))) continue;
            children.add(this.newXNode(child));
            if (!onlyFirst) continue;
            return children;
        }
        return children;
    }

    private String toXmlString(Node n, boolean viewRoot) {
        String nodeName = n.getNodeName();
        switch (n.getNodeType()) {
            case 3: {
                if (viewRoot) {
                    return XNode.encodeText(n.getNodeValue());
                }
                return "";
            }
            case 1: {
                String attr = this.getAttributesString(n);
                if (n.hasChildNodes()) {
                    return this.getChildrenRecursive(n, nodeName, attr, viewRoot);
                }
                if (viewRoot) {
                    return "<" + nodeName + attr + " />";
                }
                return "";
            }
        }
        return "";
    }

    private String getChildrenRecursive(Node n, String nodeName, String attr, boolean viewRoot) {
        StringBuilder sb = new StringBuilder();
        if (viewRoot) {
            sb.append("<" + nodeName + attr + ">");
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            sb.append(this.toXmlString(child, true));
        }
        if (viewRoot) {
            sb.append("</" + nodeName + ">");
        }
        return sb.toString();
    }

    private String getAttributesString(Node n) {
        StringBuilder attr = new StringBuilder();
        if (n.getNodeType() == 1 && n.hasAttributes()) {
            for (int i = 0; i < n.getAttributes().getLength(); ++i) {
                String aName = n.getAttributes().item(i).getNodeName();
                String aValue = n.getAttributes().item(i).getNodeValue();
                attr.append(" " + aName + "=\"" + XNode.encodeAttribute(aValue) + "\"");
            }
        }
        return attr.toString();
    }

    public String toXmlDocument() {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.node);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException tce) {
            throw new XmlException(tce.getException() == null ? tce : tce.getException());
        }
    }
}

