/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;

public class PropertiesFactory {
    public Properties getPropertiesFromClassPath(String fileName) {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (stream != null) {
                Properties prop = new Properties();
                prop.load(stream);
                return prop;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public Properties getPropertiesFromFilename(String fileName) {
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(fileName));
            return prop;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Properties getPropertiesFromSystemProperty(String fileName, String defaultFileName) {
        try {
            String propsFileName = System.getProperty(fileName, defaultFileName);
            Properties prop = new Properties();
            URL url = null;
            File fp = new File(propsFileName);
            if (fp.exists()) {
                url = fp.toURI().toURL();
                String optionsFileCharsetProperty = fileName.concat(".charset");
                String charsetName = System.getProperty(optionsFileCharsetProperty, Charset.defaultCharset().name());
                InputStream in = url.openStream();
                prop.load(new InputStreamReader(in, charsetName));
                return prop;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

