/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.auto.common;

import io.jbock.auto.common.AnnotationOutput;
import io.jbock.auto.common.AnnotationValues;
import io.jbock.auto.common.Equivalence;
import io.jbock.auto.common.MoreElements;
import io.jbock.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class AnnotationMirrors {
    private static final Equivalence<AnnotationMirror> ANNOTATION_MIRROR_EQUIVALENCE = new Equivalence<AnnotationMirror>(){

        @Override
        protected boolean doEquivalent(AnnotationMirror left, AnnotationMirror right) {
            return MoreTypes.equivalence().equivalent(left.getAnnotationType(), right.getAnnotationType()) && AnnotationValues.equivalence().pairwise().equivalent(AnnotationMirrors.getAnnotationValuesWithDefaults(left).values(), AnnotationMirrors.getAnnotationValuesWithDefaults(right).values());
        }

        @Override
        protected int doHash(AnnotationMirror annotation) {
            DeclaredType type = annotation.getAnnotationType();
            Collection<AnnotationValue> annotationValues = AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).values();
            return Arrays.hashCode(new int[]{MoreTypes.equivalence().hash(type), AnnotationValues.equivalence().pairwise().hash(annotationValues)});
        }

        public String toString() {
            return "AnnotationMirrors.equivalence()";
        }
    };

    public static Equivalence<AnnotationMirror> equivalence() {
        return ANNOTATION_MIRROR_EQUIVALENCE;
    }

    public static Map<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        LinkedHashMap<ExecutableElement, AnnotationValue> values = new LinkedHashMap<ExecutableElement, AnnotationValue>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = Collections.unmodifiableMap(annotation.getElementValues());
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values.put(method, declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put(method, method.getDefaultValue());
                continue;
            }
            throw new IllegalStateException("Unset annotation value without default should never happen: " + MoreElements.asType(method.getEnclosingElement()).getQualifiedName() + "." + method.getSimpleName() + "()");
        }
        return values;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String elementName) {
        return AnnotationMirrors.getAnnotationElementAndValue(annotationMirror, elementName).getValue();
    }

    public static Map.Entry<ExecutableElement, AnnotationValue> getAnnotationElementAndValue(AnnotationMirror annotationMirror, String elementName) {
        Objects.requireNonNull(annotationMirror);
        Objects.requireNonNull(elementName);
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : AnnotationMirrors.getAnnotationValuesWithDefaults(annotationMirror).entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(elementName)) continue;
            return entry;
        }
        throw new IllegalArgumentException(String.format("@%s does not define an element %s()", MoreElements.asType(annotationMirror.getAnnotationType().asElement()).getQualifiedName(), elementName));
    }

    public static Set<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, Class<? extends Annotation> annotationClass) {
        String name = annotationClass.getCanonicalName();
        if (name == null) {
            return Set.of();
        }
        return AnnotationMirrors.getAnnotatedAnnotations(element, name);
    }

    public static Set<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, TypeElement annotation) {
        return element.getAnnotationMirrors().stream().filter(input -> MoreElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotation)).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, String annotationName) {
        return element.getAnnotationMirrors().stream().filter(input -> MoreElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotationName)).collect(Collectors.toUnmodifiableSet());
    }

    public static String toString(AnnotationMirror annotationMirror) {
        return AnnotationOutput.toString(annotationMirror);
    }

    private AnnotationMirrors() {
    }
}

