/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.auto.common;

import io.jbock.auto.common.AnnotationMirrors;
import io.jbock.auto.common.AnnotationOutput;
import io.jbock.auto.common.Equivalence;
import io.jbock.auto.common.MoreTypes;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AnnotationValues {
    private static final Equivalence<AnnotationValue> ANNOTATION_VALUE_EQUIVALENCE = new Equivalence<AnnotationValue>(){

        @Override
        protected boolean doEquivalent(AnnotationValue left, AnnotationValue right) {
            return left.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationValue>(){

                @Override
                protected Boolean defaultAction(Object left, AnnotationValue right) {
                    return left.equals(right.accept(new SimpleAnnotationValueVisitor8<Object, Void>(){

                        @Override
                        protected Object defaultAction(Object object, Void unused) {
                            return object;
                        }
                    }, null));
                }

                @Override
                public Boolean visitAnnotation(AnnotationMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationMirror>(){

                        @Override
                        protected Boolean defaultAction(Object right, AnnotationMirror left) {
                            return false;
                        }

                        @Override
                        public Boolean visitAnnotation(AnnotationMirror right, AnnotationMirror left) {
                            return AnnotationMirrors.equivalence().equivalent(left, right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitArray(List<? extends AnnotationValue> left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, List<? extends AnnotationValue>>(){

                        @Override
                        protected Boolean defaultAction(Object ignored, List<? extends AnnotationValue> alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitArray(List<? extends AnnotationValue> right, List<? extends AnnotationValue> left) {
                            return AnnotationValues.equivalence().pairwise().equivalent(left, right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitType(TypeMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, TypeMirror>(){

                        @Override
                        protected Boolean defaultAction(Object ignored, TypeMirror alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitType(TypeMirror right, TypeMirror left) {
                            return MoreTypes.equivalence().equivalent(left, right);
                        }
                    }, left);
                }
            }, right);
        }

        @Override
        protected int doHash(AnnotationValue value) {
            return value.accept(new SimpleAnnotationValueVisitor8<Integer, Void>(){

                @Override
                public Integer visitAnnotation(AnnotationMirror value, Void ignore) {
                    return AnnotationMirrors.equivalence().hash(value);
                }

                @Override
                public Integer visitArray(List<? extends AnnotationValue> values, Void ignore) {
                    return AnnotationValues.equivalence().pairwise().hash(values);
                }

                @Override
                public Integer visitType(TypeMirror value, Void ignore) {
                    return MoreTypes.equivalence().hash(value);
                }

                @Override
                protected Integer defaultAction(Object value, Void ignored) {
                    return value.hashCode();
                }
            }, null);
        }
    };
    private static final ArrayVisitor<DeclaredType> TYPE_MIRRORS_VISITOR = new ArrayVisitor<DeclaredType>(AnnotationValues::getTypeMirror);
    private static final ArrayVisitor<AnnotationMirror> ANNOTATION_MIRRORS_VISITOR = new ArrayVisitor<AnnotationMirror>(AnnotationValues::getAnnotationMirror);
    private static final ArrayVisitor<VariableElement> ENUMS_VISITOR = new ArrayVisitor<VariableElement>(AnnotationValues::getEnum);
    private static final ArrayVisitor<String> STRINGS_VISITOR = new ArrayVisitor<String>(AnnotationValues::getString);
    private static final ArrayVisitor<Integer> INTS_VISITOR = new ArrayVisitor<Integer>(AnnotationValues::getInt);
    private static final ArrayVisitor<Long> LONGS_VISITOR = new ArrayVisitor<Long>(AnnotationValues::getLong);
    private static final ArrayVisitor<Byte> BYTES_VISITOR = new ArrayVisitor<Byte>(AnnotationValues::getByte);
    private static final ArrayVisitor<Short> SHORTS_VISITOR = new ArrayVisitor<Short>(AnnotationValues::getShort);
    private static final ArrayVisitor<Float> FLOATS_VISITOR = new ArrayVisitor<Float>(AnnotationValues::getFloat);
    private static final ArrayVisitor<Double> DOUBLES_VISITOR = new ArrayVisitor<Double>(AnnotationValues::getDouble);
    private static final ArrayVisitor<Boolean> BOOLEANS_VISITOR = new ArrayVisitor<Boolean>(AnnotationValues::getBoolean);
    private static final ArrayVisitor<Character> CHARS_VISITOR = new ArrayVisitor<Character>(AnnotationValues::getChar);
    private static final ArrayVisitor<AnnotationValue> ANNOTATION_VALUES_VISITOR = new ArrayVisitor<AnnotationValue>(x -> x);

    public static Equivalence<AnnotationValue> equivalence() {
        return ANNOTATION_VALUE_EQUIVALENCE;
    }

    public static DeclaredType getTypeMirror(AnnotationValue value) {
        return (DeclaredType)TypeMirrorVisitor.INSTANCE.visit(value);
    }

    public static AnnotationMirror getAnnotationMirror(AnnotationValue value) {
        return (AnnotationMirror)AnnotationMirrorVisitor.INSTANCE.visit(value);
    }

    public static VariableElement getEnum(AnnotationValue value) {
        return (VariableElement)EnumVisitor.INSTANCE.visit(value);
    }

    private static <T> T valueOfType(AnnotationValue annotationValue, Class<T> type) {
        Object value = annotationValue.getValue();
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("Expected " + type.getSimpleName() + ", got instead: " + value);
        }
        return type.cast(value);
    }

    public static String getString(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, String.class);
    }

    public static int getInt(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Integer.class);
    }

    public static long getLong(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Long.class);
    }

    public static byte getByte(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Byte.class);
    }

    public static short getShort(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Short.class);
    }

    public static float getFloat(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Float.class).floatValue();
    }

    public static double getDouble(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Double.class);
    }

    public static boolean getBoolean(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Boolean.class);
    }

    public static char getChar(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Character.class).charValue();
    }

    public static List<DeclaredType> getTypeMirrors(AnnotationValue value) {
        return (List)TYPE_MIRRORS_VISITOR.visit(value);
    }

    public static List<AnnotationMirror> getAnnotationMirrors(AnnotationValue value) {
        return (List)ANNOTATION_MIRRORS_VISITOR.visit(value);
    }

    public static List<VariableElement> getEnums(AnnotationValue value) {
        return (List)ENUMS_VISITOR.visit(value);
    }

    public static List<String> getStrings(AnnotationValue value) {
        return (List)STRINGS_VISITOR.visit(value);
    }

    public static List<Integer> getInts(AnnotationValue value) {
        return (List)INTS_VISITOR.visit(value);
    }

    public static List<Long> getLongs(AnnotationValue value) {
        return (List)LONGS_VISITOR.visit(value);
    }

    public static List<Byte> getBytes(AnnotationValue value) {
        return (List)BYTES_VISITOR.visit(value);
    }

    public static List<Short> getShorts(AnnotationValue value) {
        return (List)SHORTS_VISITOR.visit(value);
    }

    public static List<Float> getFloats(AnnotationValue value) {
        return (List)FLOATS_VISITOR.visit(value);
    }

    public static List<Double> getDoubles(AnnotationValue value) {
        return (List)DOUBLES_VISITOR.visit(value);
    }

    public static List<Boolean> getBooleans(AnnotationValue value) {
        return (List)BOOLEANS_VISITOR.visit(value);
    }

    public static List<Character> getChars(AnnotationValue value) {
        return (List)CHARS_VISITOR.visit(value);
    }

    public static List<AnnotationValue> getAnnotationValues(AnnotationValue value) {
        return (List)ANNOTATION_VALUES_VISITOR.visit(value);
    }

    public static String toString(AnnotationValue annotationValue) {
        return AnnotationOutput.toString(annotationValue);
    }

    private AnnotationValues() {
    }

    private static final class ArrayVisitor<T>
    extends SimpleAnnotationValueVisitor8<List<T>, Void> {
        final Function<AnnotationValue, T> visitT;

        ArrayVisitor(Function<AnnotationValue, T> visitT) {
            this.visitT = Objects.requireNonNull(visitT);
        }

        @Override
        public List<T> defaultAction(Object o, Void unused) {
            throw new IllegalStateException("Expected an array, got instead: " + o);
        }

        @Override
        public List<T> visitArray(List<? extends AnnotationValue> values, Void unused) {
            return values.stream().map(this.visitT).collect(Collectors.toUnmodifiableList());
        }
    }

    private static final class EnumVisitor
    extends DefaultVisitor<VariableElement> {
        static final EnumVisitor INSTANCE = new EnumVisitor();

        EnumVisitor() {
            super(VariableElement.class);
        }

        @Override
        public VariableElement visitEnumConstant(VariableElement value, Void unused) {
            return value;
        }
    }

    private static final class AnnotationMirrorVisitor
    extends DefaultVisitor<AnnotationMirror> {
        static final AnnotationMirrorVisitor INSTANCE = new AnnotationMirrorVisitor();

        AnnotationMirrorVisitor() {
            super(AnnotationMirror.class);
        }

        @Override
        public AnnotationMirror visitAnnotation(AnnotationMirror value, Void unused) {
            return value;
        }
    }

    private static final class TypeMirrorVisitor
    extends DefaultVisitor<DeclaredType> {
        static final TypeMirrorVisitor INSTANCE = new TypeMirrorVisitor();

        TypeMirrorVisitor() {
            super(DeclaredType.class);
        }

        @Override
        public DeclaredType visitType(TypeMirror value, Void unused) {
            return MoreTypes.asDeclared(value);
        }
    }

    private static class DefaultVisitor<T>
    extends SimpleAnnotationValueVisitor8<T, Void> {
        final Class<T> clazz;

        DefaultVisitor(Class<T> clazz) {
            this.clazz = Objects.requireNonNull(clazz);
        }

        @Override
        public T defaultAction(Object o, Void unused) {
            throw new IllegalArgumentException("Expected a " + this.clazz.getSimpleName() + ", got instead: " + o);
        }
    }
}

