/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.auto.common;

import io.jbock.auto.common.MoreElements;
import io.jbock.auto.common.MoreTypes;
import io.jbock.auto.common.Preconditions;
import io.jbock.auto.common.SuperficialValidation;
import io.jbock.auto.common.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

public abstract class BasicAnnotationProcessor
extends AbstractProcessor {
    private final Set<ElementName> deferredElementNames = new LinkedHashSet<ElementName>();
    private final Map<Step, Set<ElementName>> elementsDeferredBySteps = new LinkedHashMap<Step, Set<ElementName>>();
    private Elements elements;
    private Messager messager;
    private List<Step> steps;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.steps = new ArrayList<Step>();
        this.steps().forEach(step -> this.steps.add((Step)step));
    }

    protected abstract Iterable<? extends Step> steps();

    @Deprecated
    protected void postProcess() {
    }

    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.postProcess();
        }
    }

    private Set<TypeElement> getSupportedAnnotationTypeElements() {
        Preconditions.checkState(this.steps != null);
        return this.steps.stream().flatMap(step -> this.getSupportedAnnotationTypeElements((Step)step).stream()).collect(Collectors.toUnmodifiableSet());
    }

    private Set<TypeElement> getSupportedAnnotationTypeElements(Step step) {
        return step.annotations().stream().map(this.elements::getTypeElement).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        Preconditions.checkState(this.steps != null);
        return this.steps.stream().flatMap(step -> step.annotations().stream()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Preconditions.checkState(this.elements != null);
        Preconditions.checkState(this.messager != null);
        Preconditions.checkState(this.steps != null);
        if (roundEnv.processingOver()) {
            this.postRound(roundEnv);
            if (!roundEnv.errorRaised()) {
                LinkedHashSet<ElementName> missingElements = new LinkedHashSet<ElementName>(this.deferredElementNames);
                this.elementsDeferredBySteps.values().forEach(missingElements::addAll);
                this.reportMissingElements(missingElements);
            }
            return false;
        }
        this.process(this.validElements(roundEnv));
        this.postRound(roundEnv);
        return false;
    }

    private void process(Map<TypeElement, Set<Element>> validElements) {
        for (Step step : this.steps) {
            Set<TypeElement> annotationTypes = this.getSupportedAnnotationTypeElements(step);
            LinkedHashMap<TypeElement, Set<Element>> stepElements = new LinkedHashMap<TypeElement, Set<Element>>();
            this.indexByAnnotation(this.elementsDeferredBySteps.getOrDefault(step, Set.of()), annotationTypes);
            stepElements.putAll(this.indexByAnnotation(this.elementsDeferredBySteps.getOrDefault(step, Set.of()), annotationTypes));
            validElements.forEach((el, elements) -> {
                if (annotationTypes.contains(el)) {
                    stepElements.put((TypeElement)el, (Set<Element>)elements);
                }
            });
            if (stepElements.isEmpty()) {
                this.elementsDeferredBySteps.remove(step);
                continue;
            }
            Set<? extends Element> rejectedElements = step.process(BasicAnnotationProcessor.toClassNameKeyedMultimap(stepElements));
            this.elementsDeferredBySteps.put(step, rejectedElements.stream().map(ElementName::forAnnotatedElement).collect(Collectors.toSet()));
        }
    }

    private void reportMissingElements(Set<ElementName> missingElementNames) {
        for (ElementName missingElementName : missingElementNames) {
            Optional<? extends Element> missingElement = missingElementName.getElement(this.elements);
            if (missingElement.isPresent()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage("this " + missingElement.get().getKind().name().toLowerCase(Locale.ROOT)), missingElement.get());
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage(missingElementName.name()));
        }
    }

    private String processingErrorMessage(String target) {
        return String.format("[%s:MiscError] %s was unable to process %s because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", this.getClass().getSimpleName(), this.getClass().getCanonicalName(), target);
    }

    private Map<TypeElement, Set<Element>> validElements(RoundEnvironment roundEnv) {
        Set<ElementName> prevDeferredElementNames = Set.copyOf(this.deferredElementNames);
        this.deferredElementNames.clear();
        LinkedHashMap<TypeElement, Set<Element>> deferredElementsByAnnotation = new LinkedHashMap<TypeElement, Set<Element>>();
        for (ElementName deferredElementName : prevDeferredElementNames) {
            Optional<? extends Element> deferredElement = deferredElementName.getElement(this.elements);
            if (deferredElement.isPresent()) {
                BasicAnnotationProcessor.findAnnotatedElements(deferredElement.get(), this.getSupportedAnnotationTypeElements(), deferredElementsByAnnotation);
                continue;
            }
            this.deferredElementNames.add(deferredElementName);
        }
        LinkedHashMap<TypeElement, Set<Element>> validElements = new LinkedHashMap<TypeElement, Set<Element>>();
        LinkedHashSet<ElementName> validElementNames = new LinkedHashSet<ElementName>();
        for (TypeElement annotationType : this.getSupportedAnnotationTypeElements()) {
            Set<? extends Element> roundElements = roundEnv.getElementsAnnotatedWith(annotationType);
            Set prevRoundElements = deferredElementsByAnnotation.getOrDefault(annotationType, Set.of());
            for (Element element : Stream.concat(roundElements.stream(), prevRoundElements.stream()).collect(Collectors.toUnmodifiableSet())) {
                boolean isValidElement;
                ElementName elementName = ElementName.forAnnotatedElement(element);
                boolean bl = validElementNames.contains(elementName) || !this.deferredElementNames.contains(elementName) && SuperficialValidation.validateElement(element.getKind().equals((Object)ElementKind.PACKAGE) ? element : BasicAnnotationProcessor.getEnclosingType(element)) ? true : (isValidElement = false);
                if (isValidElement) {
                    validElements.merge(annotationType, Set.of(element), Util::mutableUnion);
                    validElementNames.add(elementName);
                    continue;
                }
                this.deferredElementNames.add(elementName);
            }
        }
        return validElements;
    }

    private Map<TypeElement, Set<Element>> indexByAnnotation(Set<ElementName> annotatedElements, Set<TypeElement> annotationTypes) {
        LinkedHashMap<TypeElement, Set<Element>> deferredElements = new LinkedHashMap<TypeElement, Set<Element>>();
        for (ElementName elementName : annotatedElements) {
            Optional<? extends Element> element = elementName.getElement(this.elements);
            if (!element.isPresent()) continue;
            BasicAnnotationProcessor.findAnnotatedElements(element.get(), annotationTypes, deferredElements);
        }
        return deferredElements;
    }

    private static void findAnnotatedElements(Element element, Set<TypeElement> annotationTypes, Map<TypeElement, Set<Element>> annotatedElements) {
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind().isClass() || element2.getKind().isInterface()) continue;
            BasicAnnotationProcessor.findAnnotatedElements(element2, annotationTypes, annotatedElements);
        }
        if (element instanceof ExecutableElement) {
            for (Element element3 : MoreElements.asExecutable(element).getParameters()) {
                BasicAnnotationProcessor.findAnnotatedElements(element3, annotationTypes, annotatedElements);
            }
        }
        for (TypeElement typeElement : annotationTypes) {
            if (!BasicAnnotationProcessor.isAnnotationPresent(element, typeElement)) continue;
            annotatedElements.merge(typeElement, Set.of(element), Util::mutableUnion);
        }
    }

    private static boolean isAnnotationPresent(Element element, TypeElement annotationType) {
        return element.getAnnotationMirrors().stream().anyMatch(mirror -> MoreTypes.asTypeElement(mirror.getAnnotationType()).equals(annotationType));
    }

    private static TypeElement getEnclosingType(Element element) {
        return element.accept(new SimpleElementVisitor8<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                return e.getEnclosingElement().accept(this, p);
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitPackage(PackageElement e, Void p) {
                throw new IllegalArgumentException();
            }
        }, null);
    }

    private static Map<String, Set<Element>> toClassNameKeyedMultimap(Map<TypeElement, Set<Element>> m) {
        return m.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, Set>(((TypeElement)e.getKey()).getQualifiedName().toString(), (Set)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Util::expectNoInvocation, LinkedHashMap::new));
    }

    private static final class ElementName {
        private final Kind kind;
        private final String name;

        private ElementName(Kind kind, Name name) {
            this.kind = Objects.requireNonNull(kind);
            this.name = name.toString();
        }

        static ElementName forAnnotatedElement(Element element) {
            return element.getKind() == ElementKind.PACKAGE ? new ElementName(Kind.PACKAGE_NAME, MoreElements.asPackage(element).getQualifiedName()) : new ElementName(Kind.TYPE_NAME, BasicAnnotationProcessor.getEnclosingType(element).getQualifiedName());
        }

        String name() {
            return this.name;
        }

        Optional<? extends Element> getElement(Elements elements) {
            return Optional.ofNullable(this.kind == Kind.PACKAGE_NAME ? elements.getPackageElement(this.name) : elements.getTypeElement(this.name));
        }

        public boolean equals(Object object) {
            if (!(object instanceof ElementName)) {
                return false;
            }
            ElementName that = (ElementName)object;
            return this.kind == that.kind && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name});
        }

        private static enum Kind {
            PACKAGE_NAME,
            TYPE_NAME;

        }
    }

    public static interface Step {
        public Set<String> annotations();

        public Set<? extends Element> process(Map<String, Set<Element>> var1);
    }
}

