/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.auto.common;

import io.jbock.auto.common.MoreTypes;
import io.jbock.auto.common.Multimap;
import io.jbock.auto.common.Overrides;
import io.jbock.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;

public final class MoreElements {
    public static PackageElement getPackage(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static PackageElement asPackage(Element element) {
        return element.accept(PackageElementVisitor.INSTANCE, null);
    }

    public static boolean isType(Element element) {
        return element.getKind().isClass() || element.getKind().isInterface();
    }

    public static TypeElement asType(Element element) {
        return element.accept(TypeElementVisitor.INSTANCE, null);
    }

    public static TypeParameterElement asTypeParameter(Element element) {
        return element.accept(TypeParameterElementVisitor.INSTANCE, null);
    }

    public static VariableElement asVariable(Element element) {
        return element.accept(VariableElementVisitor.INSTANCE, null);
    }

    public static ExecutableElement asExecutable(Element element) {
        return element.accept(ExecutableElementVisitor.INSTANCE, null);
    }

    public static boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationClass) {
        return MoreElements.getAnnotationMirror(element, annotationClass).isPresent();
    }

    public static boolean isAnnotationPresent(Element element, TypeElement annotation) {
        return MoreElements.getAnnotationMirror(element, annotation).isPresent();
    }

    public static boolean isAnnotationPresent(Element element, String annotationName) {
        return MoreElements.getAnnotationMirror(element, annotationName).isPresent();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        String name = annotationClass.getCanonicalName();
        if (name == null) {
            return Optional.empty();
        }
        return MoreElements.getAnnotationMirror(element, name);
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, TypeElement annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(annotation)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = MoreElements.asType(annotationMirror.getAnnotationType().asElement());
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static <T extends Element> Predicate<T> hasModifiers(Modifier ... modifiers) {
        return MoreElements.hasModifiers(Set.of(modifiers));
    }

    public static <T extends Element> Predicate<T> hasModifiers(Set<Modifier> modifiers) {
        return input -> input.getModifiers().containsAll(modifiers);
    }

    @Deprecated
    public static Set<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Elements elementUtils) {
        Overrides.NativeOverrides overrides = new Overrides.NativeOverrides(elementUtils);
        return MoreElements.getLocalAndInheritedMethods(type, overrides);
    }

    public static Set<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Types typeUtils, Elements elementUtils) {
        return MoreElements.getLocalAndInheritedMethods(type, new Overrides.ExplicitOverrides(typeUtils));
    }

    private static Set<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Overrides overrides) {
        PackageElement pkg = MoreElements.getPackage(type);
        LinkedHashSet<ExecutableElement> methods = new LinkedHashSet<ExecutableElement>();
        for (ExecutableElement method : MoreElements.getAllMethods(type, overrides)) {
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !MoreElements.methodVisibleFromPackage(method, pkg)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type, Types typeUtils) {
        return new Overrides.ExplicitOverrides(typeUtils).overrides(overrider, overridden, type);
    }

    public static Set<ExecutableElement> getAllMethods(TypeElement type, Types typeUtils) {
        return MoreElements.getAllMethods(type, new Overrides.ExplicitOverrides(typeUtils));
    }

    private static Set<ExecutableElement> getAllMethods(TypeElement type, Overrides overrides) {
        Multimap<String, ExecutableElement> methodMap = new Multimap<String, ExecutableElement>();
        MoreElements.getAllMethods(type, methodMap);
        LinkedHashSet<ExecutableElement> overridden = new LinkedHashSet<ExecutableElement>();
        for (Collection collection : methodMap.asMap().values()) {
            List methodList = List.copyOf(collection);
            block1: for (int i = 0; i < methodList.size(); ++i) {
                ExecutableElement methodI = (ExecutableElement)methodList.get(i);
                for (int j = i + 1; j < methodList.size(); ++j) {
                    ExecutableElement methodJ = (ExecutableElement)methodList.get(j);
                    if (!overrides.overrides(methodJ, methodI, type)) continue;
                    overridden.add(methodI);
                    continue block1;
                }
            }
        }
        return methodMap.flatValues().stream().filter(m -> !overridden.contains(m)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void getAllMethods(TypeElement type, Multimap<String, ExecutableElement> methods) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            MoreElements.getAllMethods(MoreTypes.asTypeElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            MoreElements.getAllMethods(MoreTypes.asTypeElement(type.getSuperclass()), methods);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            methods.put(executableElement.getSimpleName().toString(), executableElement);
        }
    }

    static boolean methodVisibleFromPackage(ExecutableElement method, PackageElement pkg) {
        Visibility visibility = Visibility.ofElement(method);
        switch (visibility) {
            case PRIVATE: {
                return false;
            }
            case DEFAULT: {
                return MoreElements.getPackage(method).equals(pkg);
            }
        }
        return true;
    }

    private MoreElements() {
    }

    private static abstract class CastingElementVisitor<T>
    extends SimpleElementVisitor8<T, Void> {
        private final String label;

        CastingElementVisitor(String label) {
            this.label = label;
        }

        @Override
        protected final T defaultAction(Element e, Void ignore) {
            throw new IllegalArgumentException(e + " does not represent a " + this.label);
        }
    }

    private static final class ExecutableElementVisitor
    extends CastingElementVisitor<ExecutableElement> {
        private static final ExecutableElementVisitor INSTANCE = new ExecutableElementVisitor();

        ExecutableElementVisitor() {
            super("executable element");
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement e, Void label) {
            return e;
        }
    }

    private static final class VariableElementVisitor
    extends CastingElementVisitor<VariableElement> {
        private static final VariableElementVisitor INSTANCE = new VariableElementVisitor();

        VariableElementVisitor() {
            super("variable element");
        }

        @Override
        public VariableElement visitVariable(VariableElement e, Void ignore) {
            return e;
        }
    }

    private static final class TypeParameterElementVisitor
    extends CastingElementVisitor<TypeParameterElement> {
        private static final TypeParameterElementVisitor INSTANCE = new TypeParameterElementVisitor();

        TypeParameterElementVisitor() {
            super("type parameter element");
        }

        @Override
        public TypeParameterElement visitTypeParameter(TypeParameterElement e, Void ignore) {
            return e;
        }
    }

    private static final class TypeElementVisitor
    extends CastingElementVisitor<TypeElement> {
        private static final TypeElementVisitor INSTANCE = new TypeElementVisitor();

        TypeElementVisitor() {
            super("type element");
        }

        @Override
        public TypeElement visitType(TypeElement e, Void ignore) {
            return e;
        }
    }

    private static final class PackageElementVisitor
    extends CastingElementVisitor<PackageElement> {
        private static final PackageElementVisitor INSTANCE = new PackageElementVisitor();

        PackageElementVisitor() {
            super("package element");
        }

        @Override
        public PackageElement visitPackage(PackageElement e, Void ignore) {
            return e;
        }
    }
}

