/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.auto.common;

import io.jbock.auto.common.MoreTypes;
import io.jbock.auto.common.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class SimpleAnnotationMirror
implements AnnotationMirror {
    private final TypeElement annotationType;
    private final Map<String, ? extends AnnotationValue> namedValues;
    private final Map<ExecutableElement, ? extends AnnotationValue> elementValues;

    private SimpleAnnotationMirror(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        Preconditions.checkArgument(annotationType.getKind().equals((Object)ElementKind.ANNOTATION_TYPE), "annotationType must be an annotation: %s", annotationType);
        Preconditions.checkArgument(ElementFilter.methodsIn(annotationType.getEnclosedElements()).stream().map(element -> element.getSimpleName().toString()).collect(Collectors.toSet()).equals(namedValues.keySet()), "namedValues must have values for exactly the members in %s: %s", annotationType, namedValues);
        this.annotationType = annotationType;
        this.namedValues = namedValues;
        this.elementValues = ElementFilter.methodsIn(annotationType.getEnclosedElements()).stream().collect(Collectors.toMap(Function.identity(), element -> Objects.requireNonNull((AnnotationValue)namedValues.get(element.getSimpleName().toString()))));
    }

    @Override
    public DeclaredType getAnnotationType() {
        return MoreTypes.asDeclared(this.annotationType.asType());
    }

    public Map<ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.elementValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("@").append(this.annotationType.getQualifiedName());
        if (!this.namedValues.isEmpty()) {
            builder.append('(').append(this.namedValues.entrySet().stream().map(e -> (String)e.getKey() + " = " + e.getValue()).collect(Collectors.joining(", "))).append(')');
        }
        return builder.toString();
    }

    public static AnnotationMirror of(TypeElement annotationType) {
        return SimpleAnnotationMirror.of(annotationType, Map.of());
    }

    static AnnotationMirror of(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        return new SimpleAnnotationMirror(annotationType, namedValues);
    }
}

