/*
 * Copyright (C) 2016 The Dagger Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dagger.internal.codegen.base;

import io.jbock.auto.common.AnnotationMirrors;
import io.jbock.auto.common.Equivalence;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;

/**
 * A utility class for working with {@code AnnotationMirror} instances, similar to {@code
 * AnnotationMirrors}.
 */
public final class MoreAnnotationMirrors {
  private MoreAnnotationMirrors() {}

  /**
   * Wraps an {@code Optional} of a type in an {@code Optional} of a {@code Equivalence.Wrapper} for
   * that type.
   */
  public static Optional<Equivalence.Wrapper<AnnotationMirror>> wrapOptionalInEquivalence(
      Optional<AnnotationMirror> optional) {
    return optional.map(AnnotationMirrors.equivalence()::wrap);
  }

  /**
   * Unwraps an {@code Optional} of a {@code Equivalence.Wrapper} into an {@code Optional} of the
   * underlying type.
   */
  public static Optional<AnnotationMirror> unwrapOptionalEquivalence(
      Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedOptional) {
    return wrappedOptional.map(Equivalence.Wrapper::get);
  }
}
