/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.contrib;

import io.jbock.util.Optional;

final class AnsiStyle {
    private static final char ESC = '\u001b';
    private static final String CSI = "\u001b[";
    private static final String RESET = "\u001b[m";
    private final boolean ansi;

    private AnsiStyle(boolean ansi) {
        this.ansi = ansi;
    }

    static AnsiStyle create(boolean ansi) {
        return new AnsiStyle(ansi);
    }

    private Optional<String> paint(String text, Style style) {
        if (!this.ansi) {
            return Optional.empty();
        }
        return Optional.of((Object)(CSI + style.code + "m" + text + RESET));
    }

    Optional<String> bold(String text) {
        return this.paint(text, Style.BOLD);
    }

    String red(String text) {
        return (String)this.paint(text, Style.FG_RED).orElse((Object)text);
    }

    private static enum Style {
        BOLD(1),
        FG_RED(31);

        final int code;

        private Style(int code) {
            this.code = code;
        }
    }
}

