/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.contrib;

import io.jbock.util.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jbock.model.CommandModel;
import net.jbock.model.Item;
import net.jbock.model.Multiplicity;
import net.jbock.model.Option;
import net.jbock.model.Parameter;

final class Synopsis {
    private final List<Option> options;
    private final List<Parameter> parameters;
    private final String programName;

    private Synopsis(String programName, List<Option> options, List<Parameter> parameters) {
        this.options = options;
        this.parameters = parameters;
        this.programName = programName;
    }

    static Synopsis create(CommandModel context) {
        return new Synopsis(context.programName(), context.options(), context.parameters());
    }

    List<String> createSynopsis(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(prefix);
        result.add(this.programName);
        if (this.optionalOptions().findAny().isPresent()) {
            result.add("[OPTIONS]");
        }
        for (Option option : this.requiredOptions()) {
            String firstName = option.names().get(0);
            result.add(String.format("%s %s", firstName, option.paramLabel()));
        }
        block5: for (Parameter param2 : this.regularParameters()) {
            Multiplicity skew = param2.multiplicity();
            String paramLabel = param2.paramLabel();
            switch (skew) {
                case OPTIONAL: {
                    result.add("[" + paramLabel + "]");
                    continue block5;
                }
                case REQUIRED: {
                    result.add(paramLabel);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unexpected skew: " + skew);
        }
        this.repeatableParameter().ifPresent(param -> result.add(param.paramLabel() + "..."));
        return result;
    }

    private Stream<Option> optionalOptions() {
        return Synopsis.filterBySkew(this.options, (Multiplicity sk) -> sk != Multiplicity.REQUIRED);
    }

    private List<Option> requiredOptions() {
        return Synopsis.filterBySkew(this.options, Multiplicity.REQUIRED).collect(Collectors.toList());
    }

    private List<Parameter> regularParameters() {
        return Synopsis.filterBySkew(this.parameters, (Multiplicity sk) -> sk != Multiplicity.REPEATABLE).collect(Collectors.toList());
    }

    private Optional<Parameter> repeatableParameter() {
        return Synopsis.filterBySkew(this.parameters, Multiplicity.REPEATABLE).findAny().map(Optional::of).orElse(Optional.empty());
    }

    private static <E extends Item> Stream<E> filterBySkew(List<E> items, Multiplicity skew) {
        return Synopsis.filterBySkew(items, (Multiplicity sk) -> sk == skew);
    }

    private static <E extends Item> Stream<E> filterBySkew(List<E> items, Predicate<Multiplicity> p) {
        return items.stream().filter(o -> p.test(o.multiplicity()));
    }
}

