/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.contrib;

import io.jbock.util.Optional;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jbock.contrib.AnsiStyle;
import net.jbock.contrib.Synopsis;
import net.jbock.model.CommandModel;
import net.jbock.model.Item;
import net.jbock.model.Option;
import net.jbock.model.Parameter;

final class UsageDocumentation {
    private static final int CONTINUATION_INDENT_USAGE = 8;
    private final Pattern whitespace = Pattern.compile("\\s+");
    private final PrintStream out;
    private final int terminalWidth;
    private final Map<String, String> messages;
    private final String descriptionKey;
    private final List<String> descriptionLines;
    private final List<Option> options;
    private final List<Parameter> parameters;
    private final Synopsis synopsis;
    private final AnsiStyle ansiStyle;
    private final int maxWidthOptions;
    private final int maxWidthParameters;

    private UsageDocumentation(PrintStream out, int terminalWidth, Map<String, String> messages, String descriptionKey, List<String> descriptionLines, List<Option> options, List<Parameter> parameters, Synopsis synopsis, AnsiStyle ansiStyle, int maxWidthOptions, int maxWidthParameters) {
        this.descriptionKey = descriptionKey;
        this.descriptionLines = descriptionLines;
        this.out = out;
        this.terminalWidth = terminalWidth;
        this.messages = messages;
        this.options = options;
        this.parameters = parameters;
        this.synopsis = synopsis;
        this.ansiStyle = ansiStyle;
        this.maxWidthOptions = maxWidthOptions;
        this.maxWidthParameters = maxWidthParameters;
    }

    static Builder builder(CommandModel context) {
        return new Builder(context);
    }

    void printUsageDocumentation() {
        ArrayList<String> description = new ArrayList<String>();
        String desc = this.messages.get(this.descriptionKey);
        if (desc != null) {
            Collections.addAll(description, this.whitespace.split(desc, -1));
        } else {
            for (String line : this.descriptionLines) {
                Collections.addAll(description, this.whitespace.split(line, -1));
            }
        }
        this.makeLines("", description).forEach(this.out::println);
        if (!description.isEmpty()) {
            this.out.println();
        }
        String optionsFormat = "  %1$-" + this.maxWidthOptions + "s ";
        String paramsFormat = "  %1$-" + this.maxWidthParameters + "s ";
        String indent_p = String.join((CharSequence)"", Collections.nCopies(this.maxWidthParameters + 4, " "));
        String indent_o = String.join((CharSequence)"", Collections.nCopies(this.maxWidthOptions + 4, " "));
        this.out.println((String)this.ansiStyle.bold("USAGE").orElse((Object)"USAGE"));
        String indent_u = String.join((CharSequence)"", Collections.nCopies(8, " "));
        this.makeLines(indent_u, this.synopsis.createSynopsis(" ")).forEach(this.out::println);
        if (!this.parameters.isEmpty()) {
            this.out.println();
            this.out.println((String)this.ansiStyle.bold("PARAMETERS").orElse((Object)"PARAMETERS"));
        }
        for (Parameter parameter : this.parameters) {
            this.printItemDocumentation(parameter, String.format(paramsFormat, parameter.namesOverview()), indent_p);
        }
        if (!this.options.isEmpty()) {
            this.out.println();
            this.out.println((String)this.ansiStyle.bold("OPTIONS").orElse((Object)"OPTIONS"));
        }
        for (Option option : this.options) {
            this.printItemDocumentation(option, String.format(optionsFormat, option.namesOverview()), indent_o);
        }
    }

    private void printItemDocumentation(Item item, String itemName, String indent) {
        Optional message = item.descriptionKey().isEmpty() ? Optional.empty() : Optional.ofNullable((Object)this.messages.get(item.descriptionKey()));
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(itemName);
        tokens.addAll((Collection)message.map(String::trim).map(s -> this.whitespace.split((CharSequence)s, -1)).map(Arrays::asList).orElseGet(() -> item.description().stream().map(s -> this.whitespace.split((CharSequence)s, -1)).flatMap(Arrays::stream).collect(Collectors.toList())));
        this.makeLines(indent, tokens).forEach(this.out::println);
    }

    private List<String> makeLines(String indent, List<String> tokens) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        int i = 0;
        while (i < tokens.size()) {
            boolean fresh;
            String token = tokens.get(i);
            boolean bl = fresh = line.length() == 0;
            if (!fresh && token.length() + line.length() + 1 > this.terminalWidth) {
                result.add(line.toString());
                line.setLength(0);
                continue;
            }
            if (i > 0) {
                line.append(fresh ? indent : " ");
            }
            line.append(token);
            ++i;
        }
        if (line.length() > 0) {
            result.add(line.toString());
        }
        return result;
    }

    static final class Builder {
        private final CommandModel model;
        private PrintStream out = System.err;
        private int terminalWidth = 80;
        private boolean ansi = true;
        private Map<String, String> messages = Collections.emptyMap();

        private Builder(CommandModel model) {
            this.model = model;
        }

        Builder withTerminalWidth(int width) {
            this.terminalWidth = width == 0 ? this.terminalWidth : width;
            return this;
        }

        Builder withMessages(Map<String, String> map) {
            this.messages = map;
            return this;
        }

        Builder withAnsi(boolean ansi) {
            this.ansi = ansi;
            return this;
        }

        Builder withOutputStream(PrintStream out) {
            this.out = out;
            return this;
        }

        UsageDocumentation build() {
            return new UsageDocumentation(this.out, this.terminalWidth, this.messages, this.model.descriptionKey(), this.model.descriptionLines(), this.model.options(), this.model.parameters(), Synopsis.create(this.model), AnsiStyle.create(this.ansi), this.maxWidth(this.model.options()), this.maxWidth(this.model.parameters()));
        }

        private int maxWidth(List<? extends Item> items) {
            return items.stream().map(Item::namesOverview).mapToInt(String::length).max().orElse(0);
        }
    }
}

