/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.model;

import java.util.ArrayList;
import java.util.List;
import net.jbock.model.Item;
import net.jbock.model.Option;
import net.jbock.model.Parameter;
import net.jbock.util.ItemType;
import net.jbock.util.ParseRequest;

public final class CommandModel {
    private final ParseRequest request;
    private final String descriptionKey;
    private final List<String> descriptionLines;
    private final String programName;
    private final boolean superCommand;
    private final boolean unixClustering;
    private final List<Option> options;
    private final List<Parameter> parameters;

    private CommandModel(ParseRequest request, String descriptionKey, List<String> descriptionLines, String programName, boolean superCommand, boolean unixClustering, List<Option> options, List<Parameter> parameters) {
        this.request = request;
        this.descriptionKey = descriptionKey;
        this.descriptionLines = descriptionLines;
        this.programName = programName;
        this.superCommand = superCommand;
        this.unixClustering = unixClustering;
        this.options = options;
        this.parameters = parameters;
    }

    public static Builder builder(ParseRequest request) {
        return new Builder(request);
    }

    public String descriptionKey() {
        return this.descriptionKey;
    }

    public List<String> descriptionLines() {
        return this.descriptionLines;
    }

    public String programName() {
        return this.programName;
    }

    public List<Option> options() {
        return this.options;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public boolean isSuperCommand() {
        return this.superCommand;
    }

    public boolean isUnixClustering() {
        return this.unixClustering;
    }

    public ParseRequest request() {
        return this.request;
    }

    public Item getItem(ItemType itemType, int index) {
        switch (itemType) {
            case PARAMETER: {
                return this.parameters.get(index);
            }
            case OPTION: {
                return this.options.get(index);
            }
        }
        throw new AssertionError((Object)"all cases exhausted");
    }

    public static final class Builder {
        private final ParseRequest request;
        private String descriptionKey = "";
        private final List<String> descriptionLines = new ArrayList<String>();
        private String programName;
        private boolean superCommand;
        private boolean unixClustering;
        private final List<Option> options = new ArrayList<Option>();
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        private Builder(ParseRequest request) {
            this.request = request;
        }

        public Builder withDescriptionKey(String descriptionKey) {
            this.descriptionKey = descriptionKey;
            return this;
        }

        public Builder addDescriptionLine(String descriptionLine) {
            this.descriptionLines.add(descriptionLine);
            return this;
        }

        public Builder withProgramName(String programName) {
            this.programName = programName;
            return this;
        }

        public Builder withSuperCommand(boolean superCommand) {
            this.superCommand = superCommand;
            return this;
        }

        public Builder withUnixClustering(boolean unixClustering) {
            this.unixClustering = unixClustering;
            return this;
        }

        public Builder addOption(Option option) {
            this.options.add(option);
            return this;
        }

        public Builder addParameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public CommandModel build() {
            return new CommandModel(this.request, this.descriptionKey, this.descriptionLines, this.programName, this.superCommand, this.unixClustering, this.options, this.parameters);
        }
    }
}

