/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.jbock.model.Item;
import net.jbock.model.Multiplicity;
import net.jbock.util.ItemType;

public final class Parameter
extends Item {
    Parameter(String paramLabel, String descriptionKey, List<String> description, Multiplicity multiplicity) {
        super(paramLabel, descriptionKey, description, multiplicity);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String namesOverview() {
        return this.paramLabel();
    }

    @Override
    public String namesOverviewError() {
        return this.itemType().name().toLowerCase(Locale.US) + " " + this.paramLabel();
    }

    @Override
    public ItemType itemType() {
        return ItemType.PARAMETER;
    }

    public static final class Builder {
        private String paramLabel;
        private String descriptionKey = "";
        private final List<String> description = new ArrayList<String>();
        private Multiplicity multiplicity = Multiplicity.REQUIRED;

        private Builder() {
        }

        public Builder withParamLabel(String paramLabel) {
            this.paramLabel = paramLabel;
            return this;
        }

        public Builder withDescriptionKey(String descriptionKey) {
            this.descriptionKey = descriptionKey;
            return this;
        }

        public Builder addDescriptionLine(String descriptionLine) {
            this.description.add(descriptionLine);
            return this;
        }

        public Builder withMultiplicity(Multiplicity multiplicity) {
            this.multiplicity = multiplicity;
            return this;
        }

        public Parameter build() {
            return new Parameter(this.paramLabel, this.descriptionKey, this.description, this.multiplicity);
        }
    }
}

