/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.util;

import net.jbock.model.CommandModel;
import net.jbock.util.ErrTokenType;
import net.jbock.util.HasMessage;
import net.jbock.util.NotSuccess;

public final class ErrToken
extends NotSuccess
implements HasMessage {
    private final ErrTokenType errorType;
    private final String token;

    public ErrToken(CommandModel commandModel, ErrTokenType errorType, String token) {
        super(commandModel);
        this.errorType = errorType;
        this.token = token;
    }

    public ErrTokenType errorType() {
        return this.errorType;
    }

    public String token() {
        return this.token;
    }

    @Override
    public String message() {
        switch (this.errorType) {
            case MISSING_ARGUMENT: {
                return "Missing argument after option name: " + this.token;
            }
            case INVALID_OPTION: {
                return "Invalid option: " + this.token;
            }
            case EXCESS_PARAM: {
                return "Excess param: " + this.token;
            }
            case OPTION_REPETITION: {
                return String.format("Option '%s' is a repetition", this.token);
            }
            case INVALID_UNIX_GROUP: {
                return "Invalid token: " + this.token;
            }
        }
        throw new AssertionError((Object)"all cases exhausted");
    }
}

