/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.util;

import io.jbock.util.Optional;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class ParseRequest {
    private final Optional<Path> path;
    private final List<String> args;
    private final boolean helpRequested;

    private ParseRequest(Optional<Path> path, List<String> args, boolean helpRequested) {
        this.path = path;
        this.args = args;
        this.helpRequested = helpRequested;
    }

    public static Builder standardBuilder(String[] args) {
        if (args.length >= 1 && args[0].length() >= 2 && args[0].startsWith("@")) {
            String fileName = args[0].substring(1);
            List<String> rest = List.of(args).subList(1, args.length);
            return ParseRequest.expand(Paths.get(fileName, new String[0]), rest);
        }
        return ParseRequest.simple(List.of(args));
    }

    public static Builder simple(List<String> args) {
        return new Builder((Optional<Path>)Optional.empty(), args);
    }

    public static Builder expand(Path atFile, List<String> rest) {
        return new Builder((Optional<Path>)Optional.of((Object)atFile), rest);
    }

    public Optional<Path> path() {
        return this.path;
    }

    public List<String> args() {
        return this.args;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public static final class Builder {
        private final Optional<Path> path;
        private final List<String> rest;
        private boolean helpRequested;

        private Builder(Optional<Path> path, List<String> rest) {
            this.path = path;
            this.rest = rest;
        }

        public Builder withHelpRequested(boolean helpRequested) {
            this.helpRequested = helpRequested;
            return this;
        }

        public ParseRequest build() {
            return new ParseRequest(this.path, this.rest, this.helpRequested);
        }
    }
}

