/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.util;

import io.jbock.util.Either;
import java.util.function.Function;
import net.jbock.util.ConverterFailure;
import net.jbock.util.ConverterReturnedNull;
import net.jbock.util.ConverterThrewException;

public abstract class StringConverter<T>
implements Function<String, Either<ConverterFailure, T>> {
    protected abstract T convert(String var1) throws Exception;

    public static <T> StringConverter<T> create(final Function<String, T> function) {
        return new StringConverter<T>(){

            @Override
            public T convert(String token) {
                return function.apply(token);
            }
        };
    }

    @Override
    public final Either<ConverterFailure, T> apply(String s) {
        try {
            T result = this.convert(s);
            if (result == null) {
                return Either.left((Object)new ConverterReturnedNull());
            }
            return Either.right(result);
        }
        catch (Exception e) {
            return Either.left((Object)new ConverterThrewException(e));
        }
    }
}

