/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor;

import io.jbock.simple.processor.step.ComponentFactoryStep;
import io.jbock.simple.processor.step.ComponentStep;
import io.jbock.simple.processor.step.InjectStep;
import io.jbock.simple.processor.util.BindingRegistry;
import io.jbock.simple.processor.util.ComponentElement;
import io.jbock.simple.processor.util.ExecutableElementValidator;
import io.jbock.simple.processor.util.InjectBindingValidator;
import io.jbock.simple.processor.util.Qualifiers;
import io.jbock.simple.processor.util.SafeElements;
import io.jbock.simple.processor.util.SafeTypes;
import io.jbock.simple.processor.util.SourceFileGenerator;
import io.jbock.simple.processor.util.SpecWriter;
import io.jbock.simple.processor.util.TypeElementValidator;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.writing.ComponentImpl;
import io.jbock.simple.processor.writing.Generator;
import java.util.function.Function;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;

final class ProcessorComponent {
    private final TypeTool tool;
    private final Messager messager;
    private final SourceFileGenerator sourceFileGenerator;
    private final ComponentImpl componentImpl;
    private final Function<ComponentElement, Generator> generatorFactory;
    private final Function<ComponentElement, BindingRegistry> bindingRegistryFactory;
    private final Qualifiers qualifiers;
    private final SpecWriter specWriter;
    private final ComponentStep componentStep;
    private final InjectStep injectStep;
    private final InjectBindingValidator injectBindingValidator;
    private final TypeElementValidator typeElementValidator;
    private final ExecutableElementValidator executableElementValidator;
    private final SafeTypes types;
    private final SafeElements elements;
    private final ComponentFactoryStep componentFactoryStep;

    ProcessorComponent(ProcessingEnvironment processingEnvironment) {
        this.types = new SafeTypes(processingEnvironment.getTypeUtils());
        this.elements = new SafeElements(processingEnvironment.getElementUtils());
        this.qualifiers = new Qualifiers(this.elements);
        Filer filer = processingEnvironment.getFiler();
        this.tool = new TypeTool(this.elements, this.types);
        this.messager = processingEnvironment.getMessager();
        this.sourceFileGenerator = new SourceFileGenerator(filer, this.messager);
        this.injectBindingValidator = new InjectBindingValidator(this.tool);
        this.typeElementValidator = new TypeElementValidator();
        this.executableElementValidator = new ExecutableElementValidator(this.tool, this.typeElementValidator);
        this.componentImpl = new ComponentImpl();
        this.bindingRegistryFactory = BindingRegistry.factory();
        this.generatorFactory = component -> Generator.create(this.bindingRegistryFactory.apply((ComponentElement)component), this.componentImpl, component);
        this.specWriter = new SpecWriter(this.sourceFileGenerator, this.messager);
        this.componentStep = new ComponentStep(this.messager, this.tool, this.qualifiers, this.typeElementValidator, this.generatorFactory, this.specWriter);
        this.injectStep = new InjectStep(this.injectBindingValidator, this.executableElementValidator, this.messager);
        this.componentFactoryStep = new ComponentFactoryStep(this.messager, this.typeElementValidator);
    }

    ComponentStep componentStep() {
        return this.componentStep;
    }

    InjectStep injectStep() {
        return this.injectStep;
    }

    ComponentFactoryStep componentFactoryStep() {
        return this.componentFactoryStep;
    }
}

