/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.InjectBinding;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.util.Qualifiers;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.Visitors;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class DependencyRequest {
    private final Key key;
    private final Element requestingElement;
    private final Qualifiers qualifiers;
    private final TypeTool tool;
    private final Supplier<Optional<InjectBinding>> binding = Suppliers.memoize(() -> this.keyElement().flatMap(element -> {
        TypeElement typeElement = Visitors.TYPE_ELEMENT_VISITOR.visit((Element)element);
        if (typeElement == null) {
            return Optional.empty();
        }
        List allMembers = this.tool().elements().getAllMembers(typeElement).stream().filter(m -> m.getAnnotation(Inject.class) != null).collect(Collectors.toList());
        if (allMembers.isEmpty()) {
            return Optional.empty();
        }
        ExecutableElement m2 = Visitors.EXECUTABLE_ELEMENT_VISITOR.visit((Element)allMembers.get(0));
        if (m2 == null) {
            return Optional.empty();
        }
        if (m2.getKind() == ElementKind.CONSTRUCTOR) {
            return Optional.of(InjectBinding.createConstructor(this.qualifiers(), this.tool(), m2));
        }
        return Optional.of(InjectBinding.createMethod(this.qualifiers(), this.tool(), m2));
    }));

    public DependencyRequest(Key key, Element requestingElement, Qualifiers qualifiers, TypeTool tool) {
        this.key = key;
        this.requestingElement = requestingElement;
        this.qualifiers = qualifiers;
        this.tool = tool;
    }

    public Key key() {
        return this.key;
    }

    public Element requestingElement() {
        return this.requestingElement;
    }

    public Optional<InjectBinding> binding() {
        return this.binding.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DependencyRequest that = (DependencyRequest)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.requestingElement, that.requestingElement);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.requestingElement);
    }

    public String toString() {
        return "[key=" + this.key + ", requestingElement=" + this.requestingElement + "]";
    }

    private TypeTool tool() {
        return this.tool;
    }

    private Qualifiers qualifiers() {
        return this.qualifiers;
    }

    private Optional<Element> keyElement() {
        return this.tool().types().asElement(this.key().type());
    }
}

