/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.jbock.javapoet.ClassName;
import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.util.Qualifiers;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.Visitors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class InjectBinding
extends Binding {
    private final ExecutableElement bindingElement;
    private final Function<CodeBlock, CodeBlock> invokeExpression;
    private final Supplier<TypeElement> enclosingElement = Suppliers.memoize(() -> {
        Element el = this.element().getEnclosingElement();
        return Objects.requireNonNull(Visitors.TYPE_ELEMENT_VISITOR.visit(el));
    });
    private final Supplier<String> accessMethodName = Suppliers.memoize(() -> {
        if (this.element().getKind() == ElementKind.CONSTRUCTOR) {
            return "create";
        }
        return this.element().getSimpleName().toString();
    });
    private final Supplier<ClassName> accessClassName = Suppliers.memoize(() -> {
        Element enclosing = this.element().getEnclosingElement();
        ClassName className = ClassName.get(Visitors.TYPE_ELEMENT_VISITOR.visit(enclosing));
        return className.topLevelClassName().peerClass(String.join((CharSequence)"_", className.simpleNames()) + "_Access");
    });
    private final Supplier<String> signature = Suppliers.memoize(() -> {
        CodeBlock deps = this.dependencies().stream().map(d -> CodeBlock.of("$L", d.requestingElement().getSimpleName().toString())).collect(CodeBlock.joining(", "));
        if (this.element().getKind() == ElementKind.CONSTRUCTOR) {
            return CodeBlock.of("$T($L)", this.key().typeName(), deps).toString();
        }
        return CodeBlock.of("$T.$L($L)", this.element().getEnclosingElement().asType(), this.element().getSimpleName(), deps).toString();
    });
    private final Supplier<String> suggestedVariableName = Suppliers.memoize(() -> {
        String[] tokens = this.key().typeName().toString().split("[.]");
        String simpleName = tokens[tokens.length - 1];
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    });
    private final List<DependencyRequest> dependencies;

    public InjectBinding(Key key, ExecutableElement bindingElement, Function<CodeBlock, CodeBlock> invokeExpression, List<DependencyRequest> dependencies) {
        super(key);
        this.bindingElement = bindingElement;
        this.invokeExpression = invokeExpression;
        this.dependencies = dependencies;
    }

    public static InjectBinding create(Key key, ExecutableElement bindingElement, Function<CodeBlock, CodeBlock> invokeExpression, Qualifiers qualifiers, TypeTool tool) {
        ArrayList<DependencyRequest> dependencies = new ArrayList<DependencyRequest>();
        for (VariableElement variableElement : bindingElement.getParameters()) {
            dependencies.add(new DependencyRequest(Key.create(variableElement.asType(), qualifiers.getQualifier(variableElement)), variableElement, qualifiers, tool));
        }
        return new InjectBinding(key, bindingElement, invokeExpression, dependencies);
    }

    public static InjectBinding createConstructor(Qualifiers qualifiers, TypeTool tool, ExecutableElement element) {
        Element typeElement = element.getEnclosingElement();
        Key key = Key.create(typeElement.asType(), qualifiers.getQualifier(element));
        return InjectBinding.create(key, element, params -> CodeBlock.of("new $T($L)", typeElement.asType(), params), qualifiers, tool);
    }

    public static InjectBinding createMethod(Qualifiers qualifiers, TypeTool tool, ExecutableElement element) {
        TypeMirror returnType = element.getReturnType();
        Key key = Key.create(returnType, qualifiers.getQualifier(element));
        return InjectBinding.create(key, element, params -> CodeBlock.of("$T.$L($L)", element.getEnclosingElement().asType(), element.getSimpleName().toString(), params), qualifiers, tool);
    }

    public String suggestedVariableName() {
        return this.suggestedVariableName.get();
    }

    @Override
    public ExecutableElement element() {
        return this.bindingElement;
    }

    @Override
    public List<DependencyRequest> dependencies() {
        return this.dependencies;
    }

    public CodeBlock invokeExpression(CodeBlock params) {
        return this.invokeExpression.apply(params);
    }

    public ClassName accessClassName() {
        return this.accessClassName.get();
    }

    public String accessMethodName() {
        return this.accessMethodName.get();
    }

    public TypeElement enclosingElement() {
        return this.enclosingElement.get();
    }

    public String signature() {
        return this.signature.get();
    }

    public String toString() {
        return "InjectBinding[" + this.key() + "]";
    }
}

