/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.jbock.javapoet.TypeName;
import io.jbock.simple.processor.util.SimpleAnnotation;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public final class Key {
    private final TypeMirror type;
    private final TypeName typeName;
    private final Optional<SimpleAnnotation> qualifier;

    private Key(TypeMirror type, TypeName typeName, Optional<SimpleAnnotation> qualifier) {
        this.type = type;
        this.typeName = typeName;
        this.qualifier = qualifier;
    }

    public static Key create(TypeMirror mirror, Optional<SimpleAnnotation> qualifier) {
        TypeName typeName = TypeName.get(mirror);
        return new Key(mirror, typeName, qualifier);
    }

    public String toString() {
        if (this.qualifier.isEmpty()) {
            return "" + this.typeName;
        }
        return this.typeName + "-" + this.qualifier.orElseThrow();
    }

    public TypeName typeName() {
        return this.typeName;
    }

    public TypeMirror type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return this.typeName.equals(key.typeName) && this.qualifier.equals(key.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.qualifier);
    }
}

