/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.jbock.auto.common.BasicAnnotationProcessor;
import io.jbock.simple.Component;
import io.jbock.simple.processor.util.TypeElementValidator;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class ComponentFactoryStep
implements BasicAnnotationProcessor.Step {
    private final TypeElementValidator validator;
    private final Messager messager;

    public ComponentFactoryStep(Messager messager, TypeElementValidator validator) {
        this.messager = messager;
        this.validator = validator;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Component.Factory.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        try {
            List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement typeElement : typeElements) {
                this.validator.validate(typeElement);
                Element enclosing = typeElement.getEnclosingElement();
                if (enclosing.getAnnotation(Component.class) == null) {
                    throw new ValidationFailure("The @Factory must be nested inside a @Component", typeElement);
                }
                if (enclosing.getEnclosedElements().stream().filter(enclosed -> enclosed.getKind().isInterface()).filter(enclosed -> enclosed.getAnnotation(Component.Factory.class) != null).count() < 2L) continue;
                throw new ValidationFailure("Found more than one @Factory", enclosing);
            }
        }
        catch (ValidationFailure f) {
            f.writeTo(this.messager);
        }
        return Set.of();
    }
}

