/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.jbock.auto.common.BasicAnnotationProcessor;
import io.jbock.jbock.javapoet.TypeSpec;
import io.jbock.simple.Component;
import io.jbock.simple.processor.util.ComponentElement;
import io.jbock.simple.processor.util.Qualifiers;
import io.jbock.simple.processor.util.SpecWriter;
import io.jbock.simple.processor.util.TypeElementValidator;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.writing.Generator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class ComponentStep
implements BasicAnnotationProcessor.Step {
    private final Messager messager;
    private final TypeTool tool;
    private final Qualifiers qualifiers;
    private final TypeElementValidator validator;
    private final Function<ComponentElement, Generator> generatorFactory;
    private final SpecWriter specWriter;

    public ComponentStep(Messager messager, TypeTool tool, Qualifiers qualifiers, TypeElementValidator validator, Function<ComponentElement, Generator> generatorFactory, SpecWriter specWriter) {
        this.messager = messager;
        this.tool = tool;
        this.qualifiers = qualifiers;
        this.validator = validator;
        this.generatorFactory = generatorFactory;
        this.specWriter = specWriter;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Component.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        try {
            List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement typeElement : typeElements) {
                this.validator.validate(typeElement);
                ComponentElement component = ComponentElement.create(typeElement, this.tool, this.qualifiers);
                component.factoryElement().ifPresent(factory -> {
                    ExecutableElement method = factory.singleAbstractMethod();
                    if (!this.tool.types().isSameType(method.getReturnType(), typeElement.asType())) {
                        throw new ValidationFailure("Factory method must return the component type", method);
                    }
                });
                TypeSpec typeSpec = this.generatorFactory.apply(component).generate();
                this.specWriter.write(component.generatedClass(), typeSpec);
            }
        }
        catch (ValidationFailure f) {
            f.writeTo(this.messager);
        }
        return Set.of();
    }
}

