/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.jbock.auto.common.BasicAnnotationProcessor;
import io.jbock.simple.Inject;
import io.jbock.simple.processor.util.ExecutableElementValidator;
import io.jbock.simple.processor.util.InjectBindingValidator;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;

public class InjectStep
implements BasicAnnotationProcessor.Step {
    private final InjectBindingValidator validator;
    private final ExecutableElementValidator executableElementValidator;
    private final Messager messager;

    public InjectStep(InjectBindingValidator validator, ExecutableElementValidator executableElementValidator, Messager messager) {
        this.validator = validator;
        this.executableElementValidator = executableElementValidator;
        this.messager = messager;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Inject.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        try {
            List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(elements);
            List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
            for (ExecutableElement constructor : constructors) {
                this.executableElementValidator.validate(constructor);
                this.validator.validateConstructor(constructor);
            }
            for (ExecutableElement method : methods) {
                this.executableElementValidator.validate(method);
                this.validator.validateStaticMethod(method);
            }
        }
        catch (ValidationFailure f) {
            f.writeTo(this.messager);
        }
        return Set.of();
    }
}

