/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.jbock.javapoet.ClassName;
import io.jbock.simple.Component;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.util.FactoryElement;
import io.jbock.simple.processor.util.Qualifiers;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public final class ComponentElement {
    private final TypeElement element;
    private final TypeTool tool;
    private final Qualifiers qualifiers;
    private final Supplier<ClassName> generatedClass = Suppliers.memoize(() -> {
        ClassName className = ClassName.get(this.element());
        return className.topLevelClassName().peerClass(String.join((CharSequence)"_", className.simpleNames()) + "_Impl");
    });
    private final Supplier<Optional<FactoryElement>> factoryElement = Suppliers.memoize(() -> {
        Iterator<? extends Element> iterator = this.element().getEnclosedElements().iterator();
        if (iterator.hasNext()) {
            boolean hasFactoryAnnotation;
            Element el = iterator.next();
            boolean bl = hasFactoryAnnotation = el.getAnnotation(Component.Factory.class) != null;
            if (!hasFactoryAnnotation) {
                return Optional.empty();
            }
            TypeElement tel = Visitors.TYPE_ELEMENT_VISITOR.visit(el);
            if (tel == null) {
                return Optional.empty();
            }
            return Optional.of(new FactoryElement(tel, this.generatedClass(), this.qualifiers()));
        }
        return Optional.empty();
    });
    private final Supplier<List<DependencyRequest>> requests = Suppliers.memoize(() -> {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.element().getEnclosedElements());
        ArrayList<DependencyRequest> result = new ArrayList<DependencyRequest>();
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            if (!method.getParameters().isEmpty()) {
                throw new ValidationFailure("The method may not have any parameters", method);
            }
            if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
                throw new ValidationFailure("Default method not allowed here", method);
            }
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                throw new ValidationFailure("The method may not return void", method);
            }
            Key key = Key.create(method.getReturnType(), this.qualifiers().getQualifier(method));
            result.add(new DependencyRequest(key, method, this.qualifiers(), this.tool()));
        }
        return result;
    });

    private ComponentElement(TypeElement element, TypeTool tool, Qualifiers qualifiers) {
        this.element = element;
        this.tool = tool;
        this.qualifiers = qualifiers;
    }

    public static ComponentElement create(TypeElement element, TypeTool tool, Qualifiers qualifiers) {
        return new ComponentElement(element, tool, qualifiers);
    }

    public TypeElement element() {
        return this.element;
    }

    public Optional<FactoryElement> factoryElement() {
        return this.factoryElement.get();
    }

    public List<DependencyRequest> getRequests() {
        return this.requests.get();
    }

    public ClassName generatedClass() {
        return this.generatedClass.get();
    }

    private TypeTool tool() {
        return this.tool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentElement that = (ComponentElement)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    private Qualifiers qualifiers() {
        return this.qualifiers;
    }
}

