/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.jbock.javapoet.TypeName;
import io.jbock.simple.processor.util.TypeElementValidator;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class ExecutableElementValidator {
    private final TypeTool tool;
    private final TypeElementValidator typeElementValidator;

    public ExecutableElementValidator(TypeTool tool, TypeElementValidator typeElementValidator) {
        this.tool = tool;
        this.typeElementValidator = typeElementValidator;
    }

    public void validate(ExecutableElement element) {
        if (element.getModifiers().contains((Object)Modifier.DEFAULT)) {
            throw new ValidationFailure("The default modifier is not allowed here", element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ValidationFailure("Type parameters are not allowed here", element);
        }
        this.checkExceptionsInDeclaration(element);
    }

    public void checkExceptionsInDeclaration(ExecutableElement element) {
        for (TypeMirror typeMirror : element.getThrownTypes()) {
            this.checkChecked(element, typeMirror, typeMirror);
        }
    }

    private void checkChecked(ExecutableElement element, TypeMirror thrown, TypeMirror mirror) {
        if (this.tool.isSameType(mirror, RuntimeException.class) || this.tool.isSameType(mirror, Error.class)) {
            return;
        }
        if (this.tool.isSameType(mirror, Throwable.class)) {
            throw new ValidationFailure("invalid throws clause: found checked exception " + TypeName.get(thrown), element);
        }
        Optional tel = this.tool.types().asElement(thrown).flatMap(el -> Optional.ofNullable(Visitors.TYPE_ELEMENT_VISITOR.visit((Element)el)));
        if (tel.isEmpty()) {
            return;
        }
        TypeElement typeElement = (TypeElement)tel.orElseThrow();
        this.typeElementValidator.checkNesting(typeElement);
        this.checkChecked(element, thrown, typeElement.getSuperclass());
    }
}

