/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.simple.processor.util.SafeElements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.DeclaredType;

public final class SimpleAnnotation {
    private final DeclaredType annotationType;
    private final List<AnnotationValue> values;

    private SimpleAnnotation(DeclaredType annotationType, List<AnnotationValue> values) {
        this.annotationType = annotationType;
        this.values = values;
    }

    public static SimpleAnnotation create(AnnotationMirror mirror, SafeElements elements) {
        DeclaredType annotationType = mirror.getAnnotationType();
        ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>(elements.getElementValuesWithDefaults(mirror).values());
        return new SimpleAnnotation(annotationType, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleAnnotation that = (SimpleAnnotation)o;
        if (!this.annotationType.equals(that.annotationType)) {
            return false;
        }
        if (this.values.size() != that.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            if (Objects.equals(this.values.get(i).getValue(), that.values.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int[] result = new int[this.values.size() + 1];
        result[0] = Objects.hashCode(this.annotationType);
        for (int i = 0; i < this.values.size(); ++i) {
            result[i + 1] = Objects.hashCode(this.values.get(i).getValue());
        }
        return Arrays.hashCode(result);
    }

    public String toString() {
        return this.annotationType.toString() + this.values;
    }
}

