/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.jbock.javapoet.TypeSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.InjectBinding;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.util.BindingRegistry;
import io.jbock.simple.processor.util.ComponentElement;
import io.jbock.simple.processor.util.Edge;
import io.jbock.simple.processor.util.FactoryElement;
import io.jbock.simple.processor.util.UniqueNameSet;
import io.jbock.simple.processor.writing.AccessibilityValidator;
import io.jbock.simple.processor.writing.ComponentImpl;
import io.jbock.simple.processor.writing.CyclePrinter;
import io.jbock.simple.processor.writing.Graph;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Generator {
    private final BindingRegistry bindingRegistry;
    private final ComponentImpl componentImpl;
    private final ComponentElement component;
    private final AccessibilityValidator validator;

    private Generator(BindingRegistry bindingRegistry, ComponentImpl componentImpl, ComponentElement component, AccessibilityValidator validator) {
        this.bindingRegistry = bindingRegistry;
        this.componentImpl = componentImpl;
        this.component = component;
        this.validator = validator;
    }

    public static Generator create(BindingRegistry bindingRegistry, ComponentImpl componentImpl, ComponentElement component) {
        return new Generator(bindingRegistry, componentImpl, component, AccessibilityValidator.create(component));
    }

    Set<Binding> analyze() {
        Graph graph = Graph.newGraph();
        for (DependencyRequest request : this.component.getRequests()) {
            Binding binding = this.bindingRegistry.getBinding(request);
            graph.addAll(this.bindingRegistry.getDependencies(binding));
        }
        for (Binding binding : graph.nodes()) {
            if (!(binding instanceof InjectBinding)) continue;
            InjectBinding b = (InjectBinding)binding;
            this.validator.checkBinding(b.element());
        }
        return this.sortNodes(graph);
    }

    Set<Binding> sortNodes(Graph graph) {
        LinkedHashSet<Binding> result = new LinkedHashSet<Binding>();
        ArrayDeque<Binding> s = new ArrayDeque<Binding>(graph.startNodes());
        while (!s.isEmpty()) {
            Binding n = (Binding)s.pop();
            result.add(n);
            for (Edge e : graph.edgesFrom(n)) {
                graph.removeEdge(e);
                Binding m = e.destination();
                if (!graph.edgesTo(m).isEmpty()) continue;
                s.push(m);
            }
        }
        if (!graph.edges().isEmpty()) {
            throw new CyclePrinter(graph).fail();
        }
        return result;
    }

    public TypeSpec generate() {
        Set<Binding> sorted = this.analyze();
        return this.componentImpl.generate(this.component, this.addNames(sorted));
    }

    Map<Key, NamedBinding> addNames(Set<Binding> sorted) {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        List parameterBindings = this.component.factoryElement().map(FactoryElement::parameterBindings).orElse(List.of());
        LinkedHashMap<Key, NamedBinding> result = new LinkedHashMap<Key, NamedBinding>();
        for (ParameterBinding b : parameterBindings) {
            String name = b.parameter().getSimpleName().toString();
            result.put(b.key(), new NamedBinding(b, name));
            uniqueNameSet.claim(name);
        }
        for (Binding binding : sorted) {
            if (!(binding instanceof InjectBinding)) continue;
            InjectBinding b = (InjectBinding)binding;
            String name = uniqueNameSet.getUniqueName(b.suggestedVariableName());
            result.put(b.key(), new NamedBinding(b, name));
        }
        return result;
    }
}

