/*
 * Decompiled with CFR 0.152.
 */
package tech.iopi.jsa.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import tech.iopi.jsa.JSClassLoader;

public class DefaultJSClassLoader
implements JSClassLoader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    @Override
    public String loadJSClass(String className) {
        String classFilePath = className.replaceAll("\\.", "/") + ".js";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classFilePath);
        if (in != null) {
            try {
                byte[] filecontent = DefaultJSClassLoader.readAllBytes(in);
                String string = new String(filecontent, "UTF-8");
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        byte[] buf = new byte[8192];
        int capacity = buf.length;
        int nread = 0;
        while (true) {
            int n;
            if ((n = in.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity <<= 1;
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }
}

