/*
 * Decompiled with CFR 0.152.
 */
package tech.iopi.jsa.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ObjectAccessor {
    private static final int NOT_MATCH = 0;
    private static final int MATCH = 1000;
    private static final int MAY_MATCH = 2;
    private static final Map<Class<?>, Class<?>> primitiveMap;
    private static final Class<?>[] EMPTY_CLASS_ARRAY;

    ObjectAccessor() {
    }

    public static <T> T constructor(Class<T> c, Object ... args) {
        Constructor<?>[] constructors;
        Constructor<?> con = null;
        Class<?>[] argTypes = ObjectAccessor.getArgTypes(args);
        int matchScore = 0;
        for (Constructor<?> constructor : constructors = c.getConstructors()) {
            Class<?>[] constructorTypes = constructor.getParameterTypes();
            boolean isVarArgs = constructor.isVarArgs();
            int score = ObjectAccessor.testMatch(argTypes, constructorTypes, isVarArgs);
            if (isVarArgs) {
                --score;
            }
            if (score == 0 || score <= matchScore) continue;
            matchScore = score;
            con = constructor;
        }
        if (con == null) {
            throw new RuntimeException(new NoSuchMethodException("no public constructor : " + c.getName() + ObjectAccessor.argumentTypesToString(argTypes)));
        }
        args = con.isVarArgs() && args != null ? ObjectAccessor.transVarArgs(con.getParameterTypes(), args) : ObjectAccessor.convertArgs(con.getParameterTypes(), args);
        try {
            return con.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object method(Object obj, String methodName, Object ... args) {
        Method m;
        Object methodObject = obj;
        Class objectClass = obj.getClass();
        if (obj instanceof Class) {
            objectClass = (Class)methodObject;
            methodObject = null;
        }
        args = (m = ObjectAccessor.getProperMethod(objectClass, methodName, methodObject == null, args)).isVarArgs() && args != null ? ObjectAccessor.transVarArgs(m.getParameterTypes(), args) : (args == null ? new Object[]{null} : ObjectAccessor.convertArgs(m.getParameterTypes(), args));
        try {
            return m.invoke(methodObject, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object[] convertArgs(Class<?>[] varTypes, Object ... args) {
        for (int i = 0; i < varTypes.length; ++i) {
            Class<?> needType = varTypes[i];
            if (needType.isPrimitive()) {
                needType = primitiveMap.get(needType);
            }
            if (Number.class.isAssignableFrom(needType)) {
                Number value = (Number)args[i];
                if (needType == Short.class) {
                    args[i] = value.shortValue();
                    continue;
                }
                if (needType == Integer.class) {
                    args[i] = value.intValue();
                    continue;
                }
                if (needType == Long.class) {
                    args[i] = value.longValue();
                    continue;
                }
                if (needType == Float.class) {
                    args[i] = Float.valueOf(value.floatValue());
                    continue;
                }
                if (needType == Double.class) {
                    args[i] = value.doubleValue();
                    continue;
                }
                if (needType != Byte.class) continue;
                args[i] = value.byteValue();
                continue;
            }
            if (needType == Boolean.class && args[i] instanceof Number) {
                int value = ((Number)args[i]).intValue();
                args[i] = value != 0;
                continue;
            }
            if (needType != Character.class) continue;
            args[i] = Character.valueOf(args[i].toString().charAt(0));
        }
        return args;
    }

    private static Object[] transVarArgs(Class<?>[] varTypes, Object ... args) {
        Object[] newArgs = new Object[varTypes.length];
        Object[] varArgs = null;
        int varArgIndex = 0;
        boolean notChecked = true;
        for (int i = 0; i < args.length; ++i) {
            if (i + 1 == varTypes.length) {
                varArgs = (Object[])Array.newInstance(varTypes[i].getComponentType(), args.length - varTypes.length + 1);
            } else if (i < varTypes.length) {
                newArgs[i] = args[i];
            }
            if (varArgs == null) continue;
            if (notChecked && args[i] != null && args[i].getClass().getComponentType() != null) {
                notChecked = false;
                varArgs = (Object[])args[i];
                break;
            }
            varArgs[varArgIndex++] = args[i];
        }
        newArgs[varTypes.length - 1] = varArgs;
        return newArgs;
    }

    private static Method getProperMethod(Class<?> c, String methodName, boolean isStatic, Object ... args) {
        Method m = null;
        Class<?>[] argTypes = ObjectAccessor.getArgTypes(args);
        Method[] methods = MethodManager.getMethods(c, methodName, argTypes.length, true);
        m = ObjectAccessor.getProperMethod(methods, isStatic, false, argTypes);
        if (m == null) {
            methods = MethodManager.getMethods(c, methodName, -1, true);
            m = ObjectAccessor.getProperMethod(methods, isStatic, true, argTypes);
        }
        if (m == null) {
            throw new RuntimeException(new NoSuchMethodException("no public " + ObjectAccessor.isStaticToString(isStatic) + " method : " + c.getName() + "." + methodName + ObjectAccessor.argumentTypesToString(argTypes)));
        }
        return m;
    }

    private static Method getProperMethod(Method[] methods, boolean isStatic, boolean isVarArgs, Class<?>[] argTypes) {
        if (methods == null) {
            return null;
        }
        Method m = null;
        int matchScore = 0;
        for (Method method : methods) {
            Class<?>[] methodTypes;
            int score;
            int mod = method.getModifiers();
            if (isStatic && (!isStatic || !Modifier.isStatic(mod)) || (score = ObjectAccessor.testMatch(argTypes, methodTypes = method.getParameterTypes(), isVarArgs)) == 0 || score <= matchScore) continue;
            matchScore = score;
            m = method;
        }
        return m;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int testMatch(Class<?>[] argTypes, Class<?>[] paramTypes, boolean isVarArgs) {
        if (!isVarArgs && paramTypes.length != argTypes.length) {
            return 0;
        }
        Class<?> param = null;
        int total = 2;
        int i = 0;
        while (true) {
            int score;
            Class<?> arg;
            block9: {
                if (i >= argTypes.length) {
                    return total;
                }
                arg = argTypes[i];
                if (isVarArgs && i + 1 == paramTypes.length) {
                    if (arg.getComponentType() == null) {
                        param = paramTypes[i].getComponentType();
                        break block9;
                    } else {
                        score = ObjectAccessor.testMatch(arg, paramTypes[i]);
                        if (score == 0) {
                            return 0;
                        }
                        return total + score;
                    }
                }
                if (i < paramTypes.length) {
                    param = paramTypes[i];
                }
            }
            score = ObjectAccessor.testMatch(arg, param);
            if (score == 0) {
                return 0;
            }
            total += score;
            ++i;
        }
    }

    private static int testMatch(Class<?> argType, Class<?> paramType) {
        if (argType == null) {
            if (paramType.isPrimitive()) {
                return 0;
            }
            return 2;
        }
        if (!paramType.isPrimitive()) {
            if (argType.equals(paramType)) {
                return 1000;
            }
            if (paramType.isAssignableFrom(argType)) {
                return 2;
            }
            if (Number.class.isAssignableFrom(paramType) && Number.class.isAssignableFrom(argType)) {
                return 2;
            }
            return 0;
        }
        return ObjectAccessor.primitiveEquals(argType, paramType);
    }

    private static int primitiveEquals(Class<?> wrapper, Class<?> prim) {
        if (prim.equals(wrapper)) {
            return 1000;
        }
        Class<?> primitiveClass = primitiveMap.get(prim);
        if (primitiveClass.equals(wrapper)) {
            return 2;
        }
        if (Number.class.isAssignableFrom(primitiveClass) && Number.class.isAssignableFrom(wrapper)) {
            return 2;
        }
        return 0;
    }

    private static Class<?>[] getArgTypes(Object ... args) {
        if (args == null) {
            return EMPTY_CLASS_ARRAY;
        }
        int len = args.length;
        Class[] types = new Class[len];
        for (int i = 0; i < len; ++i) {
            if (args[i] == null) continue;
            types[i] = args[i].getClass();
        }
        return types;
    }

    private static String isStaticToString(boolean isStatic) {
        if (isStatic) {
            return " static";
        }
        return "";
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    static {
        HashMap<Class<Serializable>, Class> tmp = new HashMap<Class<Serializable>, Class>();
        tmp.put(Short.TYPE, Short.class);
        tmp.put(Integer.TYPE, Integer.class);
        tmp.put(Character.TYPE, Character.class);
        tmp.put(Long.TYPE, Long.class);
        tmp.put(Boolean.TYPE, Boolean.class);
        tmp.put(Float.TYPE, Float.class);
        tmp.put(Double.TYPE, Double.class);
        tmp.put(Byte.TYPE, Byte.class);
        primitiveMap = Collections.unmodifiableMap(tmp);
        EMPTY_CLASS_ARRAY = new Class[1];
    }

    private static class MethodManager {
        private static Map<Class<?>, Map<String, Method[]>> publicClassMethodCache = new HashMap();
        private static Map<Class<?>, Map<String, Method[]>> otherClassMethodCache = new HashMap();

        private MethodManager() {
        }

        public static Method[] getMethods(Class<?> c, String name, int argLen, boolean isPublic) {
            Map<String, Method[]> classMethods = MethodManager.getClassMethods(c, isPublic);
            return classMethods.get(MethodManager.getMethodKey(name, argLen));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map<String, Method[]> getClassMethods(Class<?> c, boolean isPublic) {
            Map<String, Method[]> classMethods = null;
            Map<Class<?>, Map<String, Method[]>> needCache = publicClassMethodCache;
            if (!isPublic) {
                needCache = otherClassMethodCache;
            }
            Object object = publicClassMethodCache;
            synchronized (object) {
                classMethods = needCache.get(c);
            }
            if (classMethods == null) {
                object = c;
                synchronized (object) {
                    Map<Class<?>, Map<String, Method[]>> map = publicClassMethodCache;
                    synchronized (map) {
                        classMethods = needCache.get(c);
                    }
                    if (classMethods == null) {
                        LinkedHashMap<String, ArrayList<Method>> mMap = new LinkedHashMap<String, ArrayList<Method>>();
                        Method[] allMethods = null;
                        allMethods = isPublic ? c.getMethods() : c.getDeclaredMethods();
                        for (Method m : allMethods) {
                            String mKey;
                            ArrayList<Method> methods;
                            if (!isPublic && Modifier.isPublic(m.getModifiers())) continue;
                            int typesLen = m.getParameterTypes().length;
                            if (m.isVarArgs()) {
                                typesLen = -1;
                            }
                            if ((methods = (ArrayList<Method>)mMap.get(mKey = MethodManager.getMethodKey(m.getName(), typesLen))) == null) {
                                methods = new ArrayList<Method>();
                                mMap.put(mKey, methods);
                            }
                            methods.add(m);
                        }
                        classMethods = new HashMap<String, Method[]>();
                        for (Map.Entry entry : mMap.entrySet()) {
                            classMethods.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new Method[0]));
                        }
                        Map<Class<?>, Map<String, Method[]>> map2 = publicClassMethodCache;
                        synchronized (map2) {
                            needCache.put(c, classMethods);
                        }
                    }
                }
            }
            return classMethods;
        }

        private static String getMethodKey(String methodName, int argLen) {
            return argLen + methodName;
        }
    }
}

