/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import chatimage.com.madgag.gif.fmsware.GifDecoder;
import chatimage.net.sf.image4j.codec.ico.ICODecoder;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;

public class ChatImageHandler {
    public static void AddChatImage(ChatImageFrame frame, String url) {
        ChatImageCode.CACHE_MAP.put(url, frame);
    }

    public static void AddChatImage(BufferedImage image, String url) {
        ChatImageHandler.AddChatImage(new ChatImageFrame(image), url);
    }

    public static void AddChatImage(InputStream image, String url) {
        ChatImageHandler.AddChatImage(new ChatImageFrame(image), url);
    }

    public static void AddChatImageError(String url, ChatImageFrame.FrameError error) {
        ChatImageCode.CACHE_MAP.put(url, new ChatImageFrame(error));
    }

    public static void loadGif(InputStream is, String url) {
        CompletableFuture.supplyAsync(() -> {
            GifDecoder gd = new GifDecoder();
            int status = gd.read(is);
            if (status != 0) {
                ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
                return null;
            }
            ChatImageFrame frame = new ChatImageFrame(gd.getFrame(0));
            for (int i = 1; i < gd.getFrameCount(); ++i) {
                frame.append(new ChatImageFrame(gd.getFrame(i)));
            }
            frame.checkLoad();
            ChatImageCode.CACHE_MAP.put(url, frame);
            return null;
        });
    }

    public static void loadGif(byte[] is, String url) {
        ChatImageHandler.loadGif(new ByteArrayInputStream(is), url);
    }

    public static void loadFile(byte[] input, String url) {
        ChatImageCode.ChatImageType t = ChatImageHandler.getPicType(input);
        if (t == ChatImageCode.ChatImageType.GIF) {
            ChatImageHandler.loadGif(input, url);
        } else if (t == ChatImageCode.ChatImageType.ICO) {
            try {
                List<BufferedImage> images = ICODecoder.read(new ByteArrayInputStream(input));
                ChatImageHandler.AddChatImage(images.get(0), url);
            }
            catch (IOException ex) {
                ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
        } else if (t == ChatImageCode.ChatImageType.PNG) {
            try {
                ChatImageHandler.AddChatImage(ImageIO.read(new ByteArrayInputStream(input)), url);
            }
            catch (IOException ex) {
                ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
        } else {
            ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.IMAGE_TYPE_NOT_SUPPORT);
        }
    }

    public static void loadFile(InputStream input, String url) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = input.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException ex) {
            ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            return;
        }
        byte[] byteArray = buffer.toByteArray();
        ChatImageHandler.loadFile(byteArray, url);
    }

    public static void loadFile(String url) {
        try {
            ChatImageHandler.loadFile(Files.newInputStream(Paths.get(url, new String[0]), new OpenOption[0]), url);
        }
        catch (IOException ex) {
            ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static ChatImageCode.ChatImageType getPicType(byte[] is) {
        byte[] b = new byte[4];
        System.arraycopy(is, 0, b, 0, b.length);
        String type_ = ChatImageHandler.bytesToHex(b).toUpperCase();
        if (type_.startsWith("47494638")) {
            return ChatImageCode.ChatImageType.GIF;
        }
        if (type_.startsWith("00000100")) {
            return ChatImageCode.ChatImageType.ICO;
        }
        if (type_.startsWith("52494646")) {
            return ChatImageCode.ChatImageType.WEBP;
        }
        return ChatImageCode.ChatImageType.PNG;
    }
}

