/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.imageio.ImageIO;

public class ChatImageFrame<T> {
    private int width;
    private int height;
    private int originalHeight;
    private int originalWidth;
    private T id;
    private final List<ChatImageFrame<T>> siblings = Lists.newArrayList();
    public static TextureHelper<?> textureHelper;
    private FrameError error = FrameError.OTHER_ERROR;
    private int index = 0;
    private int butter = 0;

    public ChatImageFrame(InputStream image) {
        try {
            TextureReader<?> temp = textureHelper.loadTexture(image);
            this.id = temp.getId();
            this.originalWidth = temp.getWidth();
            this.originalHeight = temp.getHeight();
        }
        catch (IOException e) {
            this.error = FrameError.FILE_LOAD_ERROR;
        }
    }

    public ChatImageFrame(BufferedImage image) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            TextureReader<?> temp = textureHelper.loadTexture(new ByteArrayInputStream(os.toByteArray()));
            this.id = temp.getId();
            this.originalWidth = temp.getWidth();
            this.originalHeight = temp.getHeight();
        }
        catch (IOException e) {
            this.error = FrameError.FILE_LOAD_ERROR;
        }
    }

    public ChatImageFrame<T> append(ChatImageFrame<T> frame) {
        this.siblings.add(frame);
        return this;
    }

    public ChatImageFrame(FrameError error) {
        this.error = error;
    }

    public boolean checkLoad() {
        if (this.id == null) {
            return false;
        }
        for (int i = 0; i < this.siblings.size(); ++i) {
            if (this.siblings.get(i).getId() != null) continue;
            return false;
        }
        return true;
    }

    public boolean loadImage(int limitWidth, int limitHeight) {
        if (this.id == null) {
            return false;
        }
        if (this.index == 0) {
            this.limitSize(limitWidth, limitHeight);
        } else {
            this.siblings.get(this.index - 1).limitSize(limitWidth, limitHeight);
        }
        return true;
    }

    public void limitSize(int limitWidth, int limitHeight) {
        this.width = this.originalWidth;
        this.height = this.originalHeight;
        BigDecimal b = new BigDecimal((float)this.originalHeight / (float)this.originalWidth);
        double hx = b.setScale(2, RoundingMode.HALF_UP).doubleValue();
        if (this.width > limitWidth) {
            this.width = limitWidth;
            this.height = (int)((double)limitWidth * hx);
        }
        if (this.height > limitHeight) {
            this.height = limitHeight;
            this.width = (int)((double)limitHeight / hx);
        }
    }

    public FrameError getError() {
        return this.error;
    }

    public T getId() {
        if (this.index == 0) {
            return this.id;
        }
        return this.siblings.get(this.index - 1).getId();
    }

    public int getHeight() {
        return this.height;
    }

    public List<ChatImageFrame<T>> getSiblings() {
        return this.siblings;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOriginalHeight() {
        return this.originalHeight;
    }

    public int getOriginalWidth() {
        return this.originalWidth;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getButter() {
        return this.butter;
    }

    public void setButter(int butter) {
        this.butter = butter;
    }

    @FunctionalInterface
    public static interface TextureHelper<T> {
        public TextureReader<T> loadTexture(InputStream var1) throws IOException;
    }

    public static class TextureReader<T> {
        public T id;
        public int width;
        public int height;

        public TextureReader(T id, int width, int height) {
            this.id = id;
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public T getId() {
            return this.id;
        }
    }

    public static enum FrameError {
        FILE_NOT_FOUND,
        ID_NOT_FOUND,
        FILE_LOAD_ERROR,
        OTHER_ERROR,
        SERVER_FILE_LOAD_ERROR,
        ILLEGAL_CICODE_ERROR,
        IMAGE_TYPE_NOT_SUPPORT,
        FILE_TOO_LARGE;


        public String toTranslationKey() {
            String name = this.name();
            return name.toLowerCase() + ".chatimage.exception";
        }
    }
}

