/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageHandler;
import io.github.kituin.ChatImageCode.ChatImageHttpHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class ChatImageUrl {
    private String originalUrl = "";
    private String httpUrl;
    private UrlMethod urlMethod = UrlMethod.UNKNOWN;
    private String fileUrl;
    public static NetworkHelper networkHelper;
    public static CachePathHelper cachePathHelper;

    public ChatImageUrl(String url) {
        URI uri;
        if (url == null) {
            ChatImageHandler.AddChatImageError(url, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        this.originalUrl = url.replace("\\", "/");
        try {
            uri = new URI(this.originalUrl);
        }
        catch (URISyntaxException e) {
            ChatImageHandler.AddChatImageError(this.originalUrl, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        cachePathHelper.check();
        if (Objects.equals(uri.getScheme(), "https") || Objects.equals(uri.getScheme(), "http")) {
            boolean f;
            this.urlMethod = UrlMethod.HTTP;
            this.httpUrl = uri.toString();
            if (!ChatImageCode.CACHE_MAP.containsKey(this.httpUrl) && !(f = ChatImageHttpHandler.getInputStream(this.httpUrl))) {
                ChatImageHandler.AddChatImageError(this.httpUrl, ChatImageFrame.FrameError.INVALID_HTTP_URL);
            }
        } else if (Objects.equals(uri.getScheme(), "file")) {
            this.urlMethod = UrlMethod.FILE;
            this.fileUrl = uri.toString().replace("file:///", "");
            File file = new File(this.fileUrl);
            if (!ChatImageCode.CACHE_MAP.containsKey(this.fileUrl)) {
                boolean fileExist = file.exists();
                if (fileExist) {
                    ChatImageHandler.loadFile(this.fileUrl);
                }
                networkHelper.send(this.fileUrl, file, fileExist);
            }
        } else {
            ChatImageHandler.AddChatImageError(this.originalUrl, ChatImageFrame.FrameError.INVALID_URL);
        }
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public UrlMethod getUrlMethod() {
        return this.urlMethod;
    }

    public String getUrl() {
        switch (this.urlMethod) {
            case HTTP: {
                return this.httpUrl;
            }
            case FILE: {
                return this.fileUrl;
            }
        }
        return this.originalUrl;
    }

    public String toString() {
        return this.originalUrl;
    }

    public static enum UrlMethod {
        FILE,
        HTTP,
        UNKNOWN;

    }

    @FunctionalInterface
    public static interface CachePathHelper {
        public void check();
    }

    @FunctionalInterface
    public static interface NetworkHelper {
        public void send(String var1, File var2, boolean var3);
    }
}

