/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.api.SenderV2;
import io.github.kloping.qqbot.api.v2.GroupMessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.v2.Group;
import io.github.kloping.qqbot.entities.qqpd.v2.Member;
import io.github.kloping.qqbot.http.BaseV2;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import io.github.kloping.qqbot.impl.message.v2.BaseMessageEvent;

public class BaseGroupMessageEvent
extends BaseMessageEvent
implements GroupMessageEvent,
SenderAndCidMidGetter,
SenderV2 {
    private Group subject;
    private Member sender;
    private Bot bot;
    private Integer seq = 1;

    public BaseGroupMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        super(message, jo, bot);
        this.bot = bot;
        this.metadata = jo;
        this.rawMessage = message;
        this.msgId = this.getMetadata().getString("id");
        this.sender = new Member(this.getMetadata().getJSONObject("author"));
        this.subject = new Group(this.getMetadata());
        this.getSender().setId(this.getSender().getMeta().getString("id"));
        this.getSender().setOpenid(this.getSender().getMeta().getString("member_openid"));
        this.subject.setBot(bot);
        this.sender.setBot(bot);
    }

    @Override
    public String getGroupId() {
        return this.getSubject().getId();
    }

    @Override
    public V2Result sendMessage(String text) {
        return this.sendMessage(text, this.getMsgSeq());
    }

    public V2Result sendMessage(String text, int seq) {
        V2MsgData data = new V2MsgData().setMsg_id(this.getMsgId()).setContent(text).setMsg_seq(seq);
        return this.bot.groupBaseV2.send(this.getSubject().getOpenid(), JSON.toJSONString((Object)data), Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public V2Result sendMessage(SendAble msg) {
        return (V2Result)msg.send(this).getData();
    }

    @Override
    public Result<V2Result> send(String text) {
        return new Result<V2Result>(this.sendMessage(text));
    }

    @Override
    public Result<V2Result> send(String text, RawMessage message) {
        return message.send(text, message);
    }

    @Override
    public Result send(SendAble msg) {
        return msg.send(this);
    }

    @Override
    public Group getGroup() {
        return this.getSubject();
    }

    @Override
    public String getCid() {
        return this.getSubject().getCid();
    }

    @Override
    public String getMid() {
        return this.getMsgId();
    }

    @Override
    public EnvType getEnvType() {
        return EnvType.GROUP;
    }

    @Override
    public BaseV2 getV2() {
        return this.bot.groupBaseV2;
    }

    @Override
    public Integer getMsgSeq() {
        Integer n = this.seq;
        Integer n2 = this.seq = Integer.valueOf(this.seq + 1);
        return n;
    }

    @Override
    public String toString() {
        return String.format("[type(%s) %s].%s:%s", EnvType.GROUP.name(), this.getSubject().getId(), this.getSender().getId(), this.getRawMessage().toString0());
    }

    @Override
    public String getClassName() {
        return GroupMessageEvent.class.getSimpleName();
    }

    @Override
    public Member getSender() {
        return this.sender;
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    public Integer getSeq() {
        return this.seq;
    }

    @Override
    public Group getSubject() {
        return this.subject;
    }

    @Override
    public void setBot(Bot bot) {
        this.bot = bot;
    }
}

