/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.annotations.AutoStand;
import io.github.kloping.MySpringTool.annotations.AutoStandAfter;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.common.Public;
import io.github.kloping.date.FrameUtils;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.api.event.Event;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.impl.BaseConnectedEvent;
import io.github.kloping.qqbot.interfaces.OnCloseListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import io.github.kloping.qqbot.network.Events;
import io.github.kloping.qqbot.network.WssWorker;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;

@Entity
public class AuthAndHeartbeat
implements OnPackReceive,
OnCloseListener,
Events.EventRegister {
    @AutoStand
    Logger logger;
    @AutoStand
    ContextManager contextManager;
    @AutoStand
    private WssWorker wssWorker;
    @AutoStand
    Starter.Config config;
    private Pack jumpPack = null;
    private Pack authPack = null;
    protected String sessionId = "";
    protected int newstId = 1;
    private Number heartbeatInterval;
    private ScheduledFuture scheduledFuture;
    @AutoStand
    Bot bot;

    @AutoStandAfter
    private void r0(WssWorker wssWorker) {
        wssWorker.getOnPackReceives().add(this);
        wssWorker.getCloseListeners().add(this);
    }

    @Override
    public void onClose(int code, WebSocketClient wss) {
        if (code == Starter.CODE_4006 || code == Starter.CODE_4007 || code == Starter.CODE_4008 || code == Starter.CODE_4009 || code >= Starter.CODE_4900 && code <= Starter.CODE_4913) {
            this.identifyConnect(code, wss);
        } else {
            switch (code) {
                case 4013: 
                case 4014: {
                    this.logger.error("\u65e0\u6743\u9650\u8ba2\u9605\u4e8b\u4ef6");
                    break;
                }
                case 1006: {
                    this.identifyConnect(code, wss);
                    break;
                }
                default: {
                    this.logger.error(String.format("\u6682\u672a\u5904\u7406\u7684\u5f02\u5e38code(%s)", code));
                }
            }
        }
    }

    private void identifyConnect(int code, WebSocketClient wss) {
        if (!this.config.getReconnect().booleanValue()) {
            return;
        }
        Future<?> future = (Future<?>)this.contextManager.getContextEntity(Future.class, "main_future");
        if (future != null && !future.isCancelled()) {
            future.cancel(true);
        }
        this.wssWorker.msgr = 0;
        this.wssWorker.msgs = 0;
        future = Public.EXECUTOR_SERVICE.submit(this.wssWorker);
        this.contextManager.append(future, "main_future");
    }

    private void resumeConnect(int code, WebSocketClient wss) {
        wss.reconnect();
        wss.send(String.format("{\n  \"op\": 6,\n  \"d\": {\n    \"token\": \"%s\",\n    \"session_id\": \"%s\",\n    \"seq\": %s\n  }\n}", this.contextManager.getContextEntity(String.class, "token"), this.sessionId, this.newstId));
    }

    @Override
    public boolean onReceive(Pack pack) {
        if (this.wssWorker.msgr == 0) {
            this.logger.info("Authentication");
            this.authPack = new Pack();
            this.authPack.setOp(2);
            JSONObject jo = new JSONObject();
            jo.put("token", this.contextManager.getContextEntity(String.class, "appid-token"));
            jo.put("intents", this.contextManager.getContextEntity(Integer.class, "intents"));
            jo.put("shard", this.contextManager.getContextEntity(Integer[].class, "shard"));
            jo.put("properties", new Object());
            this.authPack.setD(jo);
            this.wssWorker.webSocket.send(JSON.toJSONString((Object)this.authPack));
            this.heartbeatInterval = pack.dAsMapGet("heartbeat_interval", Long.class);
            this.jumpPack = new Pack();
            this.jumpPack.setOp(1);
            if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(true);
            }
            this.scheduledFuture = FrameUtils.SERVICE.scheduleAtFixedRate(() -> {
                if (this.newstId != -1) {
                    this.jumpPack.setD(this.newstId);
                }
                this.wssWorker.webSocket.send(JSON.toJSONString((Object)this.jumpPack));
            }, this.heartbeatInterval.longValue(), this.heartbeatInterval.longValue(), TimeUnit.MILLISECONDS);
            return true;
        }
        if (pack.getOp() == 7) {
            this.logger.waring("op 7 Reconnect");
        }
        if (pack.getS() != null) {
            this.newstId = pack.getS().intValue();
        }
        return false;
    }

    @AutoStandAfter
    private void r0(Events events) {
        events.register("READY", this);
    }

    @Override
    public Event handle(String t, JSONObject mateData, RawMessage message) {
        this.sessionId = mateData.getString("session_id");
        this.logger.info("Ready!");
        return new BaseConnectedEvent(mateData, this.bot, this.sessionId);
    }
}

