/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.event.ChannelEvent;
import io.github.kloping.qqbot.api.message.MessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.Guild;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.utils.BaseUtils;

public abstract class BaseMessageEvent
implements ChannelEvent,
MessageEvent<Member, Channel> {
    protected RawMessage message;
    protected JSONObject metadata;
    protected Member sender;
    protected Guild guild;
    protected Channel channel;
    protected Bot bot;
    protected MessageChain chain;
    @JSONField(serialize=false, deserialize=false)
    private Class<?>[] filters = null;

    public BaseMessageEvent() {
    }

    public BaseMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        this.message = message;
        this.metadata = jo;
        this.bot = bot;
        this.guild = this.getBot().getGuild(message.getGuildId());
        this.channel = this.getGuild().getChannel(message.getChannelId());
        this.sender = this.getGuild().getMember(message.getAuthor().getId());
    }

    public String toString() {
        return String.format("[type(%s) %s].%s:%s", EnvType.GUILD.name(), this.getSubject().getId(), this.getSender().getId(), this.getRawMessage().toString0());
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Channel getSubject() {
        return this.getChannel();
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public RawMessage getRawMessage() {
        return this.message;
    }

    @Override
    public JSONObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Member getSender() {
        return this.sender;
    }

    @Override
    public Result<ActionResult> send(String text) {
        return this.getRawMessage().send(text);
    }

    @Override
    public Result<ActionResult> send(String text, RawMessage message) {
        return this.getRawMessage().send(text, message);
    }

    @Override
    public Result<ActionResult> send(MessagePacket packet) {
        return this.getRawMessage().send(packet);
    }

    @Override
    public Result<ActionResult> send(RawPreMessage msg) {
        return this.getRawMessage().send(msg);
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    @Override
    public Result<ActionResult> send(SendAble msg) {
        return this.getRawMessage().send(msg);
    }

    @Override
    public MessageChain getMessage() {
        return this.chain == null ? (this.chain = BaseUtils.parseToMessageChain(this.getRawMessage(), this.filters)) : this.chain;
    }

    @Override
    public void setFilter(Class<?>[] filters) {
        this.filters = filters;
    }
}

