/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex.msg;

import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.api.SenderV2;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.AtAll;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.Keyboard;
import io.github.kloping.qqbot.entities.ex.Markdown;
import io.github.kloping.qqbot.entities.ex.MessagePreBuilder;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;

public class MessageChain
implements SendAble,
List<SendAble> {
    private final List<SendAble> data = new LinkedList<SendAble>();

    @Override
    public void forEach(Consumer<? super SendAble> consumer) {
        for (SendAble data : this.data) {
            consumer.accept(data);
        }
    }

    public MessageChain append(SendAble sendAble) {
        if (sendAble != null) {
            this.data.add(sendAble);
        }
        return this;
    }

    private MessageChain append(SendAble sendAble, MessagePreBuilder builder) {
        if (sendAble instanceof At) {
            builder.append((At)sendAble);
        } else if (sendAble instanceof AtAll) {
            builder.append((AtAll)sendAble);
        } else if (sendAble instanceof Image) {
            builder.append((Image)sendAble);
        } else if (sendAble instanceof PlainText) {
            builder.append(((PlainText)sendAble).getText());
        } else if (sendAble instanceof Emoji) {
            builder.append((Emoji)sendAble);
        }
        return this;
    }

    public MessageChain at(String id) {
        return this.append(new At("member", id));
    }

    public MessageChain image(String url) {
        return this.append(new Image(url));
    }

    public MessageChain image(byte[] bytes) {
        return this.append(new Image(bytes));
    }

    public MessageChain text(String text) {
        return this.append(new PlainText(text));
    }

    @Override
    public Result send(SenderAndCidMidGetter er) {
        if (this.data.isEmpty()) {
            return null;
        }
        if (er.getEnvType() == EnvType.GUILD) {
            MessagePreBuilder builder = new MessagePreBuilder();
            boolean flag0 = false;
            Result<V2Result> result = null;
            for (SendAble sendAble : this.data) {
                if (sendAble instanceof PlainText) {
                    builder.append(sendAble.toString());
                    continue;
                }
                if (sendAble instanceof Image) {
                    if (!flag0) {
                        builder.append((Image)sendAble);
                        flag0 = true;
                        continue;
                    }
                    er.send(builder.build());
                    builder.clear();
                    builder.append((Image)sendAble);
                    continue;
                }
                if (sendAble instanceof At) {
                    builder.append((At)sendAble);
                    continue;
                }
                if (sendAble instanceof AtAll) {
                    builder.append((AtAll)sendAble);
                    continue;
                }
                if (sendAble instanceof Emoji) {
                    builder.append((Emoji)sendAble);
                    continue;
                }
                if (!(sendAble instanceof Markdown)) continue;
                result = ((Markdown)sendAble).send(er);
            }
            if (!builder.isEmpty()) {
                result = er.send(builder.build());
            }
            return result;
        }
        SenderV2 v2 = (SenderV2)((Object)er);
        boolean flag0 = false;
        V2MsgData data = new V2MsgData();
        if (Judge.isNotEmpty((String)er.getMid())) {
            data.setMsg_id(er.getMid());
        }
        Result<V2Result> result = null;
        int sent = 0;
        for (SendAble e0 : this.data) {
            if (e0 instanceof Image) {
                Image image = (Image)e0;
                RawMessage.imagePrepare(image, er.getBot());
                if (!flag0) {
                    if (image.getFile_type() != 1) {
                        image.send(er);
                        ++sent;
                        continue;
                    }
                    flag0 = true;
                } else {
                    data.setMsg_seq(v2.getMsgSeq());
                    v2.getV2().send(er.getCid(), data.toString(), Channel.SEND_MESSAGE_HEADERS);
                    data = new V2MsgData();
                    if (Judge.isNotEmpty((String)er.getMid())) {
                        data.setMsg_id(er.getMid());
                    }
                }
                result = Judge.isNotEmpty((String)image.getUrl()) ? new Result<V2Result>(v2.getV2().sendFile(er.getCid(), String.format("{\"file_type\": %s,\"url\": \"%s\",\"srv_send_msg\": false}", image.getFile_type(), image.getUrl()), Channel.SEND_MESSAGE_HEADERS)) : new Result<V2Result>(v2.getV2().sendFile(er.getCid(), String.format("{\"file_type\": %s,\"file_data\": \"%s\",\"srv_send_msg\": false}", image.getFile_type(), Base64.getEncoder().encodeToString(image.getBytes())), Channel.SEND_MESSAGE_HEADERS));
                result.getData().logFileInfo(er.getBot().logger, image);
                data.setMsg_type(7);
                data.setMedia(new V2MsgData.Media(result.getData().getFile_info()));
                continue;
            }
            if (e0 instanceof Markdown) {
                result = ((Markdown)e0).send(er, v2.getMsgSeq());
                ++sent;
                continue;
            }
            if (e0 instanceof Keyboard) {
                data.setKeyboard(e0);
                data.setMsg_type(2);
                continue;
            }
            data.setContent(data.getContent() + e0.toString());
        }
        if (sent < this.data.size()) {
            data.setMsg_seq(v2.getMsgSeq());
            result = new Result<V2Result>(v2.getV2().send(er.getCid(), data.toString(), Channel.SEND_MESSAGE_HEADERS));
            return result;
        }
        return result;
    }

    @Override
    public SendAble get(int index) {
        return this.data.get(index);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<SendAble> iterator() {
        return this.data.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(SendAble sendAble) {
        return this.data.add(sendAble);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SendAble> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends SendAble> c) {
        return this.data.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.remove(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public SendAble set(int index, SendAble element) {
        return this.data.set(index, element);
    }

    @Override
    public void add(int index, SendAble element) {
        this.data.add(index, element);
    }

    @Override
    public SendAble remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    @Override
    public ListIterator<SendAble> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public ListIterator<SendAble> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    public List<SendAble> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    public void reSet(List<SendAble> collect) {
        this.data.clear();
        this.data.addAll(collect);
    }
}

