/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities;

import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.entities.qqpd.Guild;
import io.github.kloping.qqbot.entities.qqpd.User;
import io.github.kloping.qqbot.http.AuthV2Base;
import io.github.kloping.qqbot.http.ChannelBase;
import io.github.kloping.qqbot.http.DmsBase;
import io.github.kloping.qqbot.http.GroupBaseV2;
import io.github.kloping.qqbot.http.GuildBase;
import io.github.kloping.qqbot.http.InterActionBase;
import io.github.kloping.qqbot.http.MemberBase;
import io.github.kloping.qqbot.http.MessageBase;
import io.github.kloping.qqbot.http.UserBase;
import io.github.kloping.qqbot.http.UserBaseV2;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.interfaces.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Entity
public class Bot {
    @AutoStand
    public Logger logger;
    @AutoStand
    public InterActionBase interActionBase;
    @AutoStand
    public GuildBase guildBase;
    @AutoStand
    public UserBase userBase;
    @AutoStand
    public ChannelBase channelBase;
    @AutoStand
    public DmsBase dmsBase;
    @AutoStand
    public MessageBase messageBase;
    @AutoStand
    public MemberBase memberBase;
    @AutoStand
    public GroupBaseV2 groupBaseV2;
    @AutoStand
    public UserBaseV2 userBaseV2;
    @AutoStand
    public AuthV2Base authV2Base;
    @AutoStand
    Starter.Config config;
    private User user;
    private Map<String, Guild> guildMap = new HashMap<String, Guild>();

    private void tryLoadGuilds() {
        if (this.guildMap.isEmpty()) {
            this.user = this.userBase.botInfo();
            for (Guild guild : this.guildBase.getGuilds()) {
                guild.setBot(this);
                this.guildMap.put(guild.getId(), guild);
            }
        }
    }

    public synchronized Guild getGuild(String id) {
        Guild guild;
        this.tryLoadGuilds();
        if (!this.guildMap.containsKey(id) && (guild = this.guildBase.getGuild(id)) != null) {
            this.setGuild(guild);
        }
        return this.guildMap.get(id);
    }

    public Guild setGuild(Guild guild) {
        this.guildMap.put(guild.getId(), guild);
        return this.guildMap.get(guild.getId());
    }

    public Guild delGuild(Guild guild) {
        this.guildMap.remove(guild.getId());
        return guild;
    }

    public Collection<Guild> guilds() {
        this.tryLoadGuilds();
        return this.guildMap.values();
    }

    public synchronized User getInfo() {
        if (this.user == null) {
            this.user = this.userBase.botInfo();
        }
        return this.user;
    }

    public String getId() {
        return this.getInfo().getId();
    }

    public Starter.Config getConfig() {
        return this.config;
    }
}

