/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript;

import io.github.kscripting.kscript.cache.Cache;
import io.github.kscripting.kscript.code.Templates;
import io.github.kscripting.kscript.creator.BootstrapCreator;
import io.github.kscripting.kscript.creator.DeprecatedInfoCreator;
import io.github.kscripting.kscript.creator.IdeaProjectCreator;
import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.creator.JarArtifactCreator;
import io.github.kscripting.kscript.creator.PackageCreator;
import io.github.kscripting.kscript.model.Config;
import io.github.kscripting.kscript.model.Script;
import io.github.kscripting.kscript.parser.Parser;
import io.github.kscripting.kscript.resolver.DependencyResolver;
import io.github.kscripting.kscript.resolver.InputOutputResolver;
import io.github.kscripting.kscript.resolver.ScriptResolver;
import io.github.kscripting.kscript.resolver.SectionResolver;
import io.github.kscripting.kscript.util.Executor;
import io.github.kscripting.kscript.util.FileUtils;
import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.ScriptType;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/kscripting/kscript/KscriptHandler;", "", "executor", "Lio/github/kscripting/kscript/util/Executor;", "config", "Lio/github/kscripting/kscript/model/Config;", "options", "", "", "(Lio/github/kscripting/kscript/util/Executor;Lio/github/kscripting/kscript/model/Config;Ljava/util/Map;)V", "handle", "", "userArgs", "", "kscript"})
public final class KscriptHandler {
    @NotNull
    private final Executor executor;
    @NotNull
    private final Config config;
    @NotNull
    private final Map<String, String> options;

    public KscriptHandler(@NotNull Executor executor, @NotNull Config config, @NotNull Map<String, String> options) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.executor = executor;
        this.config = config;
        this.options = options;
    }

    public final void handle(@NotNull List<String> userArgs) {
        List list;
        Intrinsics.checkNotNullParameter(userArgs, (String)"userArgs");
        Cache cache = new Cache(this.config.getOsConfig().getCacheDir());
        if (this.options.containsKey("clear-cache")) {
            Logger.INSTANCE.info("Cleaning up cache...");
            cache.clear();
            if (!this.options.containsKey("script")) {
                return;
            }
        }
        String string = this.options.get("script");
        if (string == null) {
            throw new IllegalArgumentException("Script argument is required");
        }
        String scriptSource = string;
        if (StringsKt.isBlank((CharSequence)scriptSource)) {
            return;
        }
        boolean enableSupportApi = this.options.containsKey("text");
        List $this$handle_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (enableSupportApi) {
            $this$handle_u24lambda_u240.add(Templates.INSTANCE.getTextProcessingPreamble());
        }
        $this$handle_u24lambda_u240.add(this.config.getScriptingConfig().getCustomPreamble());
        List preambles = CollectionsKt.build((List)list);
        InputOutputResolver inputOutputResolver = new InputOutputResolver(this.config.getOsConfig(), cache);
        SectionResolver sectionResolver = new SectionResolver(inputOutputResolver, new Parser(), this.config.getScriptingConfig());
        ScriptResolver scriptResolver = new ScriptResolver(inputOutputResolver, sectionResolver, this.config.getScriptingConfig());
        if (this.options.containsKey("add-bootstrap-header")) {
            Script script = ScriptResolver.resolve$default(scriptResolver, scriptSource, null, 0, 2, null);
            new BootstrapCreator().create(script);
            return;
        }
        Script script = ScriptResolver.resolve$default(scriptResolver, scriptSource, preambles, 0, 4, null);
        if (!((Collection)script.getDeprecatedItems()).isEmpty()) {
            if (this.options.containsKey("report")) {
                Logger.INSTANCE.info(new DeprecatedInfoCreator().create(script.getDeprecatedItems()));
                return;
            }
            Logger.INSTANCE.warnMsg("There are deprecated features in scripts. Use --report option to print full report.");
        }
        Set<OsPath> resolvedDependencies2 = cache.getOrCreateDependencies(script.getDigest(), (Function0<? extends Set<OsPath>>)((Function0)new Function0<Set<? extends OsPath>>(this, script){
            final /* synthetic */ KscriptHandler this$0;
            final /* synthetic */ Script $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super(0);
            }

            @NotNull
            public final Set<OsPath> invoke() {
                List<OsPath> localArtifacts = KscriptHandler.access$getConfig$p(this.this$0).getScriptingConfig().getArtifactsDir() != null ? FileUtils.INSTANCE.getArtifactsRecursively(KscriptHandler.access$getConfig$p(this.this$0).getScriptingConfig().getArtifactsDir(), DependencyResolver.Companion.getSupportedExtensions()) : CollectionsKt.emptyList();
                return SetsKt.plus(new DependencyResolver(this.$script.getRepositories()).resolve(this.$script.getDependencies()), (Iterable)localArtifacts);
            }
        }));
        if (this.options.containsKey("idea")) {
            OsPath path2 = cache.getOrCreateIdeaProject(script.getDigest(), (Function1<? super OsPath, OsPath>)((Function1)new Function1<OsPath, OsPath>(this, script, userArgs, inputOutputResolver){
                final /* synthetic */ KscriptHandler this$0;
                final /* synthetic */ Script $script;
                final /* synthetic */ List<String> $userArgs;
                final /* synthetic */ InputOutputResolver $inputOutputResolver;
                {
                    this.this$0 = $receiver;
                    this.$script = $script;
                    this.$userArgs = $userArgs;
                    this.$inputOutputResolver = $inputOutputResolver;
                    super(1);
                }

                @NotNull
                public final OsPath invoke(@NotNull OsPath basePath) {
                    Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                    Function1 uriLocalPathProvider2 = (Function1)new Function1<URI, OsPath>(this.$inputOutputResolver){
                        final /* synthetic */ InputOutputResolver $inputOutputResolver;
                        {
                            this.$inputOutputResolver = $inputOutputResolver;
                            super(1);
                        }

                        @NotNull
                        public final OsPath invoke(@NotNull URI uri) {
                            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                            return this.$inputOutputResolver.resolveContent(uri).getLocalPath();
                        }
                    };
                    return new IdeaProjectCreator(KscriptHandler.access$getExecutor$p(this.this$0)).create(basePath, this.$script, this.$userArgs, (Function1<? super URI, OsPath>)uriLocalPathProvider2);
                }
            }));
            Logger.INSTANCE.infoMsg("Idea project available at:");
            Logger.INSTANCE.infoMsg(path2.convert(this.config.getOsConfig().getOsType()).stringPath());
            return;
        }
        if (script.getEntryPoint-_L1MFNs() != null && script.getScriptLocation().getScriptType() == ScriptType.KTS) {
            throw new IllegalStateException("@file:EntryPoint directive is just supported for kt class files");
        }
        JarArtifact jar2 = cache.getOrCreateJar(script.getDigest(), (Function1<? super OsPath, JarArtifact>)((Function1)new Function1<OsPath, JarArtifact>(this, script, resolvedDependencies2){
            final /* synthetic */ KscriptHandler this$0;
            final /* synthetic */ Script $script;
            final /* synthetic */ Set<OsPath> $resolvedDependencies;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$resolvedDependencies = $resolvedDependencies;
                super(1);
            }

            @NotNull
            public final JarArtifact invoke(@NotNull OsPath basePath) {
                Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                return new JarArtifactCreator(KscriptHandler.access$getExecutor$p(this.this$0)).create(basePath, this.$script, this.$resolvedDependencies);
            }
        }));
        if (this.options.containsKey("interactive")) {
            this.executor.runInteractiveRepl(jar2, resolvedDependencies2, script.getCompilerOpts(), script.getKotlinOpts());
            return;
        }
        if (this.options.containsKey("package")) {
            OsPath path3 = cache.getOrCreatePackage(script.getDigest(), script.getScriptLocation().getScriptName(), (Function2<? super OsPath, ? super OsPath, OsPath>)((Function2)new Function2<OsPath, OsPath, OsPath>(this, script, jar2){
                final /* synthetic */ KscriptHandler this$0;
                final /* synthetic */ Script $script;
                final /* synthetic */ JarArtifact $jar;
                {
                    this.this$0 = $receiver;
                    this.$script = $script;
                    this.$jar = $jar;
                    super(2);
                }

                @NotNull
                public final OsPath invoke(@NotNull OsPath basePath, @NotNull OsPath packagePath) {
                    Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                    Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
                    return new PackageCreator(KscriptHandler.access$getExecutor$p(this.this$0)).packageKscript(basePath, packagePath, this.$script, this.$jar);
                }
            }));
            Logger.INSTANCE.infoMsg("Packaged script '" + script.getScriptLocation().getScriptName() + "' available at path:");
            Logger.INSTANCE.infoMsg(path3.convert(this.config.getOsConfig().getOsType()).stringPath());
            return;
        }
        this.executor.executeKotlin(jar2, resolvedDependencies2, userArgs, script.getKotlinOpts());
    }

    public static final /* synthetic */ Config access$getConfig$p(KscriptHandler $this) {
        return $this.config;
    }

    public static final /* synthetic */ Executor access$getExecutor$p(KscriptHandler $this) {
        return $this.executor;
    }
}

