/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.creator;

import io.github.kscripting.kscript.code.GradleTemplates;
import io.github.kscripting.kscript.code.Templates;
import io.github.kscripting.kscript.creator.IdeaProjectCreator;
import io.github.kscripting.kscript.model.Script;
import io.github.kscripting.kscript.model.ScriptNode;
import io.github.kscripting.kscript.util.Executor;
import io.github.kscripting.kscript.util.FileUtils;
import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.shell.model.OsPath;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/kscripting/kscript/creator/IdeaProjectCreator;", "", "executor", "Lio/github/kscripting/kscript/util/Executor;", "(Lio/github/kscripting/kscript/util/Executor;)V", "create", "Lio/github/kscripting/shell/model/OsPath;", "basePath", "script", "Lio/github/kscripting/kscript/model/Script;", "userArgs", "", "", "uriLocalPathProvider", "Lkotlin/Function1;", "Ljava/net/URI;", "kscript"})
public final class IdeaProjectCreator {
    @NotNull
    private final Executor executor;

    public IdeaProjectCreator(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
    }

    @NotNull
    public final OsPath create(@NotNull OsPath basePath, @NotNull Script script, @NotNull List<String> userArgs, @NotNull Function1<? super URI, OsPath> uriLocalPathProvider2) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(userArgs, (String)"userArgs");
        Intrinsics.checkNotNullParameter(uriLocalPathProvider2, (String)"uriLocalPathProvider");
        Logger.INSTANCE.infoMsg("Setting up idea project...");
        Object object = new String[]{"src/"};
        OsPath srcPath = basePath.resolve((String[])object);
        for (ScriptNode scriptNode : script.getScriptNodes()) {
            URI sourceUri = scriptNode.getScriptLocation().getSourceUri();
            OsPath filePath = FileUtils.INSTANCE.resolveUniqueFilePath(srcPath, scriptNode.getScriptLocation().getScriptName(), scriptNode.getScriptLocation().getScriptType());
            if (sourceUri == null) {
                FileUtils.INSTANCE.createFile(filePath, CollectionsKt.joinToString$default((Iterable)scriptNode.getSections(), (CharSequence)"\n", null, null, (int)0, null, (Function1)create.1.INSTANCE, (int)30, null));
                continue;
            }
            OsPath targetPath = (OsPath)uriLocalPathProvider2.invoke((Object)sourceUri);
            Logger.INSTANCE.devMsg("link: " + filePath + ", target: " + targetPath);
            FileUtils.INSTANCE.symLinkOrCopy(filePath, targetPath);
        }
        object = new String[]{".idea/runConfigurations/Main.xml"};
        FileUtils.INSTANCE.createFile(basePath.resolve((String[])object), Templates.INSTANCE.createRunConfig(script.getRootNode().getScriptLocation().getScriptName(), script.getRootNode().getScriptLocation().getScriptType(), userArgs));
        object = new String[]{"build.gradle.kts"};
        FileUtils.INSTANCE.createFile(basePath.resolve((String[])object), GradleTemplates.INSTANCE.createGradleIdeaScript(script));
        this.executor.runGradleInIdeaProject(basePath);
        return basePath;
    }
}

