/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.code;

import io.github.kscripting.kscript.code.GradleTemplates;
import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.model.CompilerOpt;
import io.github.kscripting.kscript.model.Dependency;
import io.github.kscripting.kscript.model.Repository;
import io.github.kscripting.kscript.model.Script;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00f8\u0001\u0000J\u0019\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002\u00f8\u0001\u0000J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lio/github/kscripting/kscript/code/GradleTemplates;", "", "()V", "createCompilerOptionsSection", "", "compilerOpts", "", "Lio/github/kscripting/kscript/model/CompilerOpt;", "createGradleDependenciesSection", "dependencies", "Lio/github/kscripting/kscript/model/Dependency;", "createGradleIdeaScript", "script", "Lio/github/kscripting/kscript/model/Script;", "createGradlePackageScript", "jarArtifact", "Lio/github/kscripting/kscript/creator/JarArtifact;", "createGradleRepositoriesSection", "repositories", "Lio/github/kscripting/kscript/model/Repository;", "createGradleRepositoryCredentials", "repository", "kscript"})
public final class GradleTemplates {
    @NotNull
    public static final GradleTemplates INSTANCE = new GradleTemplates();

    private GradleTemplates() {
    }

    @NotNull
    public final String createGradleIdeaScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        KotlinVersion kotlinVersion = KotlinVersion.CURRENT;
        Object[] objectArray = new Dependency[]{Dependency.box-impl(Dependency.constructor-impl("org.jetbrains.kotlin:kotlin-stdlib")), Dependency.box-impl(Dependency.constructor-impl("org.jetbrains.kotlin:kotlin-script-runtime:" + kotlinVersion)), Dependency.box-impl(Dependency.constructor-impl("io.github.kscripting:kscript-annotations:1.5.0"))};
        Set extendedDependencies = SetsKt.plus((Set)SetsKt.setOf((Object[])objectArray), (Iterable)script.getDependencies());
        return StringsKt.trimMargin$default((String)("\n            |plugins {\n            |    id(\"org.jetbrains.kotlin.jvm\") version \"" + kotlinVersion + "\"\n            |}\n            |\n            |repositories {\n            |    mavenLocal()\n            |    mavenCentral()\n            |" + StringsKt.prependIndent$default((String)this.createGradleRepositoriesSection(script.getRepositories()), null, (int)1, null) + "\n            |}\n            |\n            |dependencies {\n            |" + StringsKt.prependIndent$default((String)this.createGradleDependenciesSection(extendedDependencies), null, (int)1, null) + "\n            |}\n            |\n            |sourceSets.getByName(\"main\").java.srcDirs(\"src\")\n            |sourceSets.getByName(\"test\").java.srcDirs(\"src\")\n            |\n            |" + this.createCompilerOptionsSection(script.getCompilerOpts()) + "\n            |"), null, (int)1, null);
    }

    @NotNull
    public final String createGradlePackageScript(@NotNull Script script, @NotNull JarArtifact jarArtifact) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)jarArtifact, (String)"jarArtifact");
        String kotlinOptions = this.createCompilerOptionsSection(script.getCompilerOpts());
        KotlinVersion kotlinVersion = KotlinVersion.CURRENT;
        Object[] objectArray = new Dependency[]{Dependency.box-impl(Dependency.constructor-impl("org.jetbrains.kotlin:kotlin-stdlib")), Dependency.box-impl(Dependency.constructor-impl("org.jetbrains.kotlin:kotlin-script-runtime:" + kotlinVersion))};
        Set extendedDependencies = SetsKt.plus((Set)SetsKt.setOf((Object[])objectArray), (Iterable)script.getDependencies());
        String capsuleApp = jarArtifact.getExecClassName();
        String baseName = script.getScriptLocation().getScriptName();
        return StringsKt.trimMargin$default((String)((Object)StringsKt.trimStart((CharSequence)("\n            |import java.io.*\n            |import java.lang.System\n            |import java.nio.file.Files\n            |import java.nio.file.Paths\n            |\n            |plugins {\n            |    id(\"org.jetbrains.kotlin.jvm\") version \"" + kotlinVersion + "\"\n            |    application\n            |}\n            |\n            |repositories {\n            |    mavenLocal()\n            |    mavenCentral()\n            |" + StringsKt.prependIndent$default((String)this.createGradleRepositoriesSection(script.getRepositories()), null, (int)1, null) + "\n            |}\n            |\n            |tasks.jar {\n            |    manifest {\n            |        attributes[\"Main-Class\"] = \"" + capsuleApp + "\"\n            |    }\n            |    baseName = \"" + baseName + "\"\n            |    configurations[\"compileClasspath\"].forEach { file: File ->\n            |        from(zipTree(file.absoluteFile))\n            |    }\n            |    duplicatesStrategy = DuplicatesStrategy.INCLUDE\n            |}\n            |\n            |tasks.register(\"makeScript\") {\n            |    dependsOn(\":jar\")\n            |    doLast {\n            |        val headerDir = layout.projectDirectory.toString()\n            |        val jarFileName = layout.buildDirectory.file(\"libs/" + baseName + ".jar\").get().toString()\n            |        val outFileName = layout.buildDirectory.file(\"libs/" + baseName + "\").get().toString()\n            |        val lineSeparator = System.getProperty(\"line.separator\").encodeToByteArray()\n            |        val headerPath = Paths.get(headerDir).resolve(\"exec_header.sh\")\n            |        val headerBytes = Files.readAllBytes(headerPath)\n            |        val jarBytes = Files.readAllBytes(Paths.get(jarFileName))\n            |        val outFile = Paths.get(outFileName).toFile()\n            |        val fileStream = FileOutputStream(outFile)\n            |\n            |        fileStream.write(headerBytes)\n            |        fileStream.write(lineSeparator)\n            |        fileStream.write(jarBytes)\n            |        fileStream.close()\n            |    }\n            |}\n            |\n            |dependencies {\n            |    implementation(files(\"" + StringsKt.replace$default((String)jarArtifact.getPath().stringPath(), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null) + "\"))\n            |" + StringsKt.prependIndent$default((String)this.createGradleDependenciesSection(extendedDependencies), null, (int)1, null) + "\n            |}\n            |\n            |" + kotlinOptions + "\n            "))).toString(), null, (int)1, null);
    }

    private final String createGradleRepositoryCredentials(Repository repository) {
        if (!StringsKt.isBlank((CharSequence)repository.getUser()) && !StringsKt.isBlank((CharSequence)repository.getPassword())) {
            return StringsKt.trimMargin$default((String)("|credentials {\n                      |    username = \"" + repository.getUser() + "\"\n                      |    password = \"" + repository.getPassword() + "\"\n                      |}"), null, (int)1, null);
        }
        return "";
    }

    private final String createGradleDependenciesSection(Set<Dependency> dependencies2) {
        return CollectionsKt.joinToString$default((Iterable)dependencies2, (CharSequence)"\n", null, null, (int)0, null, (Function1)createGradleDependenciesSection.1.INSTANCE, (int)30, null);
    }

    private final String createGradleRepositoriesSection(Set<Repository> repositories) {
        return CollectionsKt.joinToString$default((Iterable)repositories, (CharSequence)"\n", null, null, (int)0, null, (Function1)createGradleRepositoriesSection.1.INSTANCE, (int)30, null);
    }

    private final String createCompilerOptionsSection(Set<CompilerOpt> compilerOpts) {
        if (compilerOpts.isEmpty()) {
            return "";
        }
        Object jvmTarget = "";
        List freeCompilerArgs = new ArrayList();
        Iterator<CompilerOpt> iterator = compilerOpts.iterator();
        while (iterator.hasNext()) {
            String opt = iterator.next().unbox-impl();
            if (StringsKt.startsWith$default((String)opt, (String)"-jvm-target", (boolean)false, (int)2, null)) {
                jvmTarget = "jvmTarget = \"" + ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)opt, (int)11))).toString() + "\"";
                continue;
            }
            freeCompilerArgs.add(opt);
        }
        return StringsKt.trimMargin$default((String)("|tasks.withType<org.jetbrains.kotlin.gradle.tasks.KotlinCompile> {\n                  |    kotlinOptions {\n                  |        " + (String)jvmTarget + "\n                  |        freeCompilerArgs = listOf(" + CollectionsKt.joinToString$default((Iterable)freeCompilerArgs, (CharSequence)", ", null, null, (int)0, null, (Function1)createCompilerOptionsSection.1.INSTANCE, (int)30, null) + ")\n                  |    }\n                  |}"), null, (int)1, null);
    }

    public static final /* synthetic */ String access$createGradleRepositoryCredentials(GradleTemplates $this, Repository repository) {
        return $this.createGradleRepositoryCredentials(repository);
    }
}

