/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.util;

import io.github.kscripting.kscript.code.Templates;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lio/github/kscripting/kscript/util/OptionsUtils;", "", "()V", "createHelpText", "", "selfName", "options", "Lorg/apache/commons/cli/Options;", "createOptions", "kscript"})
public final class OptionsUtils {
    @NotNull
    public static final OptionsUtils INSTANCE = new OptionsUtils();

    private OptionsUtils() {
    }

    @NotNull
    public final Options createOptions() {
        Options options = new Options().addOption("i", "interactive", false, "Create interactive shell with dependencies as declared in script").addOption("t", "text", false, "Enable stdin support API for more streamlined text processing").addOption("e", "idea", false, "Open script in temporary Intellij session").addOption("s", "silent", false, "Suppress status logging").addOption("d", "development", false, "Logging of exception stack traces and additional log messages").addOption("r", "report", false, "Prints script's deprecated features report").addOption("p", "package", false, "Package script and dependencies into self-dependent binary").addOption("a", "add-bootstrap-header", false, "Prepend bash header that installs kscript if necessary").addOption("h", "help", false, "Prints help information").addOption("v", "version", false, "Prints version information").addOption("c", "clear-cache", false, "Wipes out cached script jars and urls");
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"Options()\n            .a\u2026ed script jars and urls\")");
        return options;
    }

    @NotNull
    public final String createHelpText(@NotNull String selfName, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)selfName, (String)"selfName");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        StringWriter out = new StringWriter();
        new HelpFormatter().printHelp(new PrintWriter(out), 120, Templates.INSTANCE.createUsageInfo(selfName), Templates.INSTANCE.createHeaderInfo(), options, 2, 2, Templates.INSTANCE.createFooterInfo());
        String string = Templates.INSTANCE.createTitleInfo(selfName);
        String string2 = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"out.toString()");
        return string + StringsKt.drop((String)string2, (int)7);
    }
}

